/*
 * Decompiled with CFR 0.152.
 */
package adams.core;

import adams.core.Index;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public abstract class AbstractDataBackedIndex<T>
extends Index {
    private static final long serialVersionUID = -4358263779315198808L;
    protected T m_Data;
    protected List<String> m_Names;
    protected HashMap<String, Integer> m_Indices;

    public AbstractDataBackedIndex() {
    }

    public AbstractDataBackedIndex(String index) {
        super(index);
    }

    public AbstractDataBackedIndex(String index, int max) {
        super(index, max);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Data = null;
        this.m_Names = null;
        this.m_Indices = null;
    }

    public void setData(T value) {
        this.m_Data = value;
        this.m_Names = null;
        if (this.m_Data == null) {
            this.setMax(-1);
        } else {
            this.setMax(this.getNumColumns(value));
        }
    }

    public T getData() {
        return this.m_Data;
    }

    protected abstract int getNumColumns(T var1);

    protected abstract String getColumnName(T var1, int var2);

    protected synchronized List<String> getNames() {
        if (this.m_Names == null) {
            this.m_Names = new ArrayList<String>();
            this.m_Indices = new HashMap();
            for (int i = 0; i < this.getNumColumns(this.m_Data); ++i) {
                String name = this.getColumnName(this.m_Data, i);
                this.m_Names.add(name);
                this.m_Indices.put(name, i);
            }
            Collections.sort(this.m_Names);
            Collections.reverse(this.m_Names);
        }
        return this.m_Names;
    }

    public synchronized HashMap<String, Integer> getIndices() {
        if (this.m_Names == null) {
            this.getNames();
        }
        return this.m_Indices;
    }

    protected String replaceColumnName(String s) {
        String result = s.trim();
        List<String> names = this.getNames();
        for (int i = 0; i < names.size(); ++i) {
            if (!result.equals(names.get(i))) continue;
            result = Integer.toString(this.getIndices().get(names.get(i)) + 1);
            break;
        }
        return result;
    }

    protected boolean isColumnName(String s) {
        boolean result = false;
        List<String> names = this.getNames();
        for (int i = 0; i < names.size(); ++i) {
            if (!s.equals(names.get(i))) continue;
            result = true;
            break;
        }
        return result;
    }

    @Override
    protected String clean(String s) {
        if (this.m_Data == null) {
            if (this.isPlaceholder(s)) {
                return super.clean(s);
            }
            return s;
        }
        if (this.isColumnName(s)) {
            return s;
        }
        return super.clean(s);
    }

    @Override
    protected int parse(String s, int max) {
        if (this.m_Data == null) {
            return super.parse(s, max);
        }
        return super.parse(this.replaceColumnName(s), max);
    }
}

