/*
 * Decompiled with CFR 0.152.
 */
package adams.core;

import adams.core.logging.LoggingObject;
import java.io.File;
import java.io.FileFilter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;

public class ClassCache
extends LoggingObject {
    private static final long serialVersionUID = -2973185784363491578L;
    public static final String DEFAULT_PACKAGE = "DEFAULT";
    protected Hashtable<String, HashSet<String>> m_Cache;

    public ClassCache() {
        this.initialize();
    }

    protected String cleanUp(String classname) {
        String result = classname;
        if (result.indexOf("/") > -1) {
            result = result.replace("/", ".");
        }
        if (result.indexOf("\\") > -1) {
            result = result.replace("\\", ".");
        }
        if (result.endsWith(".class")) {
            result = result.substring(0, result.length() - 6);
        }
        return result;
    }

    protected String extractPackage(String classname) {
        if (classname.indexOf(".") > -1) {
            return classname.substring(0, classname.lastIndexOf("."));
        }
        return DEFAULT_PACKAGE;
    }

    public boolean add(String classname) {
        String pkgname = this.extractPackage(classname = this.cleanUp(classname));
        if (!this.m_Cache.containsKey(pkgname)) {
            this.m_Cache.put(pkgname, new HashSet());
        }
        HashSet<String> names = this.m_Cache.get(pkgname);
        return names.add(classname);
    }

    public boolean remove(String classname) {
        String pkgname = this.extractPackage(classname = this.cleanUp(classname));
        HashSet<String> names = this.m_Cache.get(pkgname);
        if (names != null) {
            return names.remove(classname);
        }
        return false;
    }

    protected void initFromDir(String prefix, File dir) {
        File[] files;
        for (File file : files = dir.listFiles(new ClassFileFilter())) {
            if (prefix == null) {
                this.add(file.getName());
                continue;
            }
            this.add(prefix + "." + file.getName());
        }
        for (File file : files = dir.listFiles(new DirectoryFilter())) {
            if (prefix == null) {
                this.initFromDir(file.getName(), file);
                continue;
            }
            this.initFromDir(prefix + "." + file.getName(), file);
        }
    }

    protected void initFromDir(File dir) {
        if (this.isLoggingEnabled()) {
            this.getLogger().log(Level.INFO, "Analyzing directory: " + dir);
        }
        this.initFromDir(null, dir);
    }

    protected void initFromJar(File file) {
        if (this.isLoggingEnabled()) {
            this.getLogger().log(Level.INFO, "Analyzing jar: " + file);
        }
        if (!file.exists()) {
            this.getLogger().log(Level.WARNING, "Jar does not exist: " + file);
            return;
        }
        try {
            JarFile jar = new JarFile(file);
            Enumeration<JarEntry> enm = jar.entries();
            while (enm.hasMoreElements()) {
                JarEntry entry = enm.nextElement();
                if (!entry.getName().endsWith(".class")) continue;
                this.add(entry.getName());
            }
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to inspect: " + file, e);
        }
    }

    public Enumeration<String> packages() {
        return this.m_Cache.keys();
    }

    public HashSet<String> getClassnames(String pkgname) {
        if (this.m_Cache.containsKey(pkgname)) {
            return this.m_Cache.get(pkgname);
        }
        return new HashSet<String>();
    }

    protected void initialize() {
        URL[] urls;
        this.m_Cache = new Hashtable();
        URLClassLoader sysLoader = (URLClassLoader)this.getClass().getClassLoader();
        for (URL url : urls = sysLoader.getURLs()) {
            if (this.isLoggingEnabled()) {
                this.getLogger().log(Level.INFO, "Classpath URL: " + url);
            }
            File file = null;
            String part = url.toString();
            if (part.startsWith("file:")) {
                part = part.replace(" ", "%20");
                try {
                    file = new File(new URI(part));
                }
                catch (URISyntaxException e) {
                    this.getLogger().log(Level.SEVERE, "Failed to generate URI: " + part, e);
                }
            } else {
                file = new File(part);
            }
            if (file == null) {
                if (!this.isLoggingEnabled()) continue;
                this.getLogger().log(Level.INFO, "Skipping: " + part);
                continue;
            }
            if (file.isDirectory()) {
                this.initFromDir(file);
                continue;
            }
            if (!file.exists()) continue;
            this.initFromJar(file);
        }
    }

    public static void main(String[] args) {
        ClassCache cache = new ClassCache();
        Enumeration<String> packages = cache.packages();
        while (packages.hasMoreElements()) {
            String key = packages.nextElement();
            System.out.println(key + ": " + cache.getClassnames(key).size());
        }
    }

    public static class DirectoryFilter
    implements FileFilter {
        @Override
        public boolean accept(File pathname) {
            return pathname.isDirectory();
        }
    }

    public static class ClassFileFilter
    implements FileFilter {
        @Override
        public boolean accept(File pathname) {
            return pathname.getName().endsWith(".class");
        }
    }
}

