/*
 * Decompiled with CFR 0.152.
 */
package adams.core;

import adams.core.EnumWithCustomDisplay;
import adams.core.Index;
import adams.core.QuickInfoSupporter;
import adams.core.Range;
import adams.core.Utils;
import adams.core.base.BaseRegExp;
import adams.core.option.OptionConsumer;
import adams.core.option.OptionHandler;
import adams.core.option.OptionProducer;
import adams.gui.core.ColorHelper;
import java.awt.Color;
import java.util.List;

public class QuickInfoHelper {
    public static boolean hasVariable(OptionHandler handler, String property) {
        return QuickInfoHelper.getVariable(handler, property) != null;
    }

    public static String getVariable(OptionHandler handler, String property) {
        return handler.getOptionManager().getVariableForProperty(property);
    }

    public static String toString(OptionHandler handler, String property, Object current) {
        return QuickInfoHelper.toString(handler, property, current, null);
    }

    public static String toString(OptionHandler handler, String property, Object current, String prefix) {
        Object result;
        String variable = QuickInfoHelper.getVariable(handler, property);
        if (variable != null) {
            result = variable;
        } else if (current == null) {
            result = null;
        } else if (current instanceof QuickInfoSupporter) {
            String info = ((QuickInfoSupporter)current).getQuickInfo();
            result = current.getClass().getSimpleName();
            if (info != null) {
                result = (String)result + " (" + info + ")";
            }
        } else {
            result = current instanceof String ? (((String)current).length() == 0 ? null : (String)current) : (current instanceof Range ? ((Range)current).getRange() : (current instanceof Index ? ((Index)current).getIndex() : (current instanceof OptionHandler ? current.getClass().getSimpleName() : (current instanceof EnumWithCustomDisplay ? ((EnumWithCustomDisplay)current).toDisplay() : (current instanceof Class ? ((Class)current).getSimpleName() : (current instanceof OptionProducer ? current.getClass().getSimpleName() : (current instanceof OptionConsumer ? current.getClass().getSimpleName() : (current instanceof Color ? ColorHelper.toHex((Color)current) : current.toString()))))))));
        }
        if (result != null && prefix != null) {
            result = prefix + (String)result;
        }
        return result;
    }

    public static String toString(OptionHandler handler, String property, BaseRegExp current) {
        return QuickInfoHelper.toString(handler, property, current, null);
    }

    public static String toString(OptionHandler handler, String property, BaseRegExp current, String prefix) {
        return QuickInfoHelper.toString(handler, property, current, null, prefix);
    }

    public static String toString(OptionHandler handler, String property, BaseRegExp current, String ifEmpty, String prefix) {
        String result = null;
        String variable = QuickInfoHelper.getVariable(handler, property);
        if (variable != null) {
            result = variable;
        } else if (current == null) {
            result = null;
        } else if (!current.isEmpty()) {
            result = current.stringValue();
        } else if (ifEmpty != null) {
            result = ifEmpty;
        }
        if (result != null && prefix != null) {
            result = prefix + result;
        }
        return result;
    }

    public static String toString(OptionHandler handler, String property, boolean current, String text) {
        return QuickInfoHelper.toString(handler, property, current, text, null);
    }

    public static String toString(OptionHandler handler, String property, boolean current, String text, String prefix) {
        String result = "";
        String variable = QuickInfoHelper.getVariable(handler, property);
        if (variable != null) {
            result = variable;
        } else if (current) {
            if (prefix != null) {
                result = result + prefix;
            }
            result = result + text;
        }
        return result;
    }

    public static boolean add(List<String> list, String value) {
        if (value == null) {
            return false;
        }
        if (value.length() == 0) {
            return false;
        }
        list.add(value);
        return true;
    }

    public static String flatten(List<String> list) {
        if (list.size() > 0) {
            return " [" + Utils.flatten(list, ", ") + "]";
        }
        return "";
    }
}

