/*
 * Decompiled with CFR 0.152.
 */
package adams.core;

import adams.core.Properties;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;

public class StaticClassLister
implements Serializable {
    private static final long serialVersionUID = 4386916077742762389L;
    protected static StaticClassLister m_Singleton;

    private StaticClassLister() {
    }

    public String[] getClasses(String propsfile, String key) {
        return this.getClasses(new String[]{propsfile}, key);
    }

    protected List<URL> locate(String resource) {
        ArrayList<URL> result = new ArrayList<URL>();
        try {
            Enumeration<URL> urls = this.getClass().getClassLoader().getResources(resource);
            while (urls.hasMoreElements()) {
                result.add(urls.nextElement());
            }
        }
        catch (Exception e) {
            System.err.println("Failed to obtain URLs for: " + resource);
            e.printStackTrace();
        }
        return result;
    }

    public String[] getClasses(List<String> propsfiles, String key) {
        return this.getClasses(propsfiles.toArray(new String[propsfiles.size()]), key);
    }

    public String[] getClasses(String[] propsfiles, String key) {
        ArrayList<String> result = new ArrayList<String>();
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String propsfile : propsfiles) {
            urls.addAll(this.locate(propsfile));
        }
        for (URL url : urls) {
            try {
                String[] names;
                InputStream stream = url.openStream();
                Properties props = new Properties();
                props.load(stream);
                for (String name : names = props.getProperty(key, "").replace(" ", "").split(",")) {
                    if (name.length() <= 0) continue;
                    result.add(name);
                }
                stream.close();
            }
            catch (Exception e) {
                System.err.println("Failed to load: " + url);
                e.printStackTrace();
            }
        }
        Collections.sort(result);
        return result.toArray(new String[result.size()]);
    }

    public static synchronized StaticClassLister getSingleton() {
        if (m_Singleton == null) {
            m_Singleton = new StaticClassLister();
        }
        return m_Singleton;
    }
}

