/*
 * Decompiled with CFR 0.152.
 */
package adams.core;

import adams.core.CleanUpHandler;
import adams.core.CloneHandler;
import adams.core.WrapperHashSet;
import adams.core.base.BaseRegExp;
import adams.core.logging.LoggingObject;
import adams.event.VariableChangeEvent;
import adams.event.VariableChangeListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;

public class Variables
extends LoggingObject
implements CleanUpHandler,
CloneHandler<Variables> {
    private static final long serialVersionUID = -1654017967835758598L;
    public static final String START = "@{";
    public static final String END = "}";
    public static final String CHARS = "abcdefghijklmnopqrstuvwxyz_ABCDEFGHIJKLMNOPQRSTUVWXYZ-0123456789:.";
    public static final String ENVIRONMENT_VARIABLE_PREFIX = "env.";
    public static final String SYSTEM_PROPERTY_PREFIX = "system.";
    protected Hashtable<String, String> m_Variables = new Hashtable();
    protected Hashtable<String, String> m_EnvironmentVariables;
    protected Hashtable<String, String> m_SystemProperties;
    protected WrapperHashSet<VariableChangeListener> m_VariableChangeListeners = new WrapperHashSet();

    public Variables() {
        this.m_EnvironmentVariables = new Hashtable();
        Map<String, String> env = System.getenv();
        for (String key : env.keySet()) {
            this.m_EnvironmentVariables.put(ENVIRONMENT_VARIABLE_PREFIX + key, env.get(key));
        }
        this.m_SystemProperties = new Hashtable();
        Properties props = System.getProperties();
        Enumeration<?> enm = props.propertyNames();
        while (enm.hasMoreElements()) {
            String key = (String)enm.nextElement();
            this.m_SystemProperties.put(SYSTEM_PROPERTY_PREFIX + key, props.getProperty(key));
        }
    }

    public void clear() {
        this.m_Variables.clear();
    }

    public Enumeration<String> names() {
        return this.m_Variables.keys();
    }

    public Set<String> nameSet() {
        return this.m_Variables.keySet();
    }

    public void set(String name, String value) {
        if (!Variables.isValidName(name)) {
            throw new IllegalArgumentException("Invalid variable name: " + name);
        }
        String strippedName = Variables.extractName(name);
        if (strippedName.startsWith(ENVIRONMENT_VARIABLE_PREFIX)) {
            return;
        }
        if (strippedName.startsWith(SYSTEM_PROPERTY_PREFIX)) {
            return;
        }
        VariableChangeEvent.Type type = this.has(strippedName) ? VariableChangeEvent.Type.MODIFIED : VariableChangeEvent.Type.ADDED;
        if (this.isLoggingEnabled()) {
            this.getLogger().log(Level.INFO, "set: name=" + name + ", value=" + value);
        }
        this.m_Variables.put(strippedName, value);
        this.notifyVariableChangeListeners(new VariableChangeEvent(this, type, name));
    }

    public boolean has(String name) {
        if (this.m_EnvironmentVariables.containsKey(name = Variables.extractName(name))) {
            return true;
        }
        if (this.m_SystemProperties.containsKey(name)) {
            return true;
        }
        return this.m_Variables.containsKey(name);
    }

    public String get(String name) {
        return this.get(name, null);
    }

    public String remove(String name) {
        String result = this.m_Variables.remove(Variables.extractName(name));
        this.notifyVariableChangeListeners(new VariableChangeEvent(this, VariableChangeEvent.Type.REMOVED, name));
        if (this.isLoggingEnabled()) {
            this.getLogger().log(Level.INFO, "remove: name=" + name + ", value=" + result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(BaseRegExp regExp) {
        boolean result = false;
        ArrayList<String> names = new ArrayList<String>();
        Hashtable<String, String> hashtable = this.m_Variables;
        synchronized (hashtable) {
            for (String name : this.m_Variables.keySet()) {
                if (!regExp.isMatch(name)) continue;
                names.add(name);
            }
            for (String name : names) {
                this.remove(name);
            }
        }
        return result;
    }

    public String get(String name, String defValue) {
        if (this.m_EnvironmentVariables.containsKey(name = Variables.extractName(name))) {
            return this.m_EnvironmentVariables.get(name);
        }
        if (this.m_SystemProperties.containsKey(name)) {
            return this.m_SystemProperties.get(name);
        }
        if (this.m_Variables.containsKey(name)) {
            return this.m_Variables.get(name);
        }
        return defValue;
    }

    public boolean isObject(String name) {
        return false;
    }

    public Object getObject(String name) {
        return this.getObject(name, null);
    }

    public Object getObject(String name, Object defValue) {
        if (defValue == null) {
            return this.get(name, null);
        }
        return this.get(name, defValue.toString());
    }

    public int size() {
        return this.m_Variables.size();
    }

    public void addVariableChangeListener(VariableChangeListener l) {
        this.m_VariableChangeListeners.add(l);
    }

    public void removeVariableChangeListener(VariableChangeListener l) {
        this.m_VariableChangeListeners.remove(l);
    }

    public void removeVariableChangeListeners() {
        this.m_VariableChangeListeners.clear();
    }

    protected void notifyVariableChangeListeners(VariableChangeEvent e) {
        for (VariableChangeListener l : this.m_VariableChangeListeners) {
            l.variableChanged(e);
        }
    }

    public static String extractName(String variable) {
        String result = variable;
        if (result.startsWith(START) && result.endsWith(END)) {
            result = result.substring(2, result.length() - 1);
        }
        return result;
    }

    public static String[] extractNames(String expr) {
        int start;
        ArrayList<String> result = new ArrayList<String>();
        while ((start = expr.indexOf(START)) > -1) {
            int end = expr.indexOf(END, start);
            if (end <= -1) continue;
            result.add(expr.substring(start + START.length(), end + END.length() - 1));
            expr = expr.substring(end + END.length(), expr.length());
        }
        return result.toArray(new String[result.size()]);
    }

    public static String padName(String name) {
        String result = name;
        if (!result.startsWith(START) || !result.endsWith(END)) {
            result = START + result + END;
        }
        return result;
    }

    public static boolean isPlaceholder(String s) {
        boolean result;
        boolean bl = result = s.startsWith(START) && s.endsWith(END);
        if (result) {
            result = Variables.isValidName(Variables.extractName(s));
        }
        return result;
    }

    public static boolean isValidName(String s) {
        boolean result;
        String name = Variables.extractName(s);
        boolean bl = result = name.length() > 0;
        if (result) {
            for (int i = 0; i < name.length(); ++i) {
                char c = name.charAt(i);
                if (CHARS.indexOf(c) != -1) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    public static String createValidName(String s) {
        StringBuilder result = new StringBuilder();
        s = Variables.extractName(s);
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (CHARS.indexOf(c) == -1) {
                result.append("_");
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    public static String toValidName(String s) {
        return Variables.toValidName(s, "_");
    }

    public static String toValidName(String s, String replace) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char chr = s.charAt(i);
            if (chr >= '0' && chr <= '9') {
                result.append(chr);
                continue;
            }
            if (chr >= 'a' && chr <= 'z') {
                result.append(chr);
                continue;
            }
            if (chr >= 'A' && chr <= 'Z') {
                result.append(chr);
                continue;
            }
            if (chr == '_') {
                result.append(chr);
                continue;
            }
            if (chr == '-') {
                result.append(chr);
                continue;
            }
            if (chr == ':') {
                result.append(chr);
                continue;
            }
            if (chr == '.') {
                result.append(chr);
                continue;
            }
            result.append(replace);
        }
        return result.toString();
    }

    public String expand(String s) {
        return this.expand(s, s.indexOf("@{@{") > -1);
    }

    protected String doExpandEnv(String s) {
        String result = s;
        String part = "@{env.";
        if (result.indexOf(part) > -1) {
            Enumeration<String> enm = this.m_EnvironmentVariables.keys();
            while (enm.hasMoreElements() && result.indexOf(part) > -1) {
                String name = enm.nextElement();
                result = result.replace(START + name + END, this.get(name));
            }
        }
        return result;
    }

    protected String doExpandSystemProps(String s) {
        String result = s;
        String part = "@{system.";
        if (result.indexOf(part) > -1) {
            Enumeration<String> enm = this.m_SystemProperties.keys();
            while (enm.hasMoreElements() && result.indexOf(part) > -1) {
                String name = enm.nextElement();
                result = result.replace(START + name + END, this.get(name));
            }
        }
        return result;
    }

    protected String doExpandRegular(String s) {
        String result = s;
        String part = START;
        if (result.indexOf(part) > -1) {
            Enumeration<String> enm = this.names();
            while (enm.hasMoreElements() && result.indexOf(part) > -1) {
                String name = enm.nextElement();
                result = result.replace(START + name + END, this.get(name));
            }
        }
        return result;
    }

    protected String doExpand(String s) {
        String result = s;
        result = this.doExpandEnv(result);
        result = this.doExpandSystemProps(result);
        result = this.doExpandRegular(result);
        return result;
    }

    protected String expand(String s, boolean recurse) {
        String result = this.doExpand(s);
        if (recurse) {
            result = this.expand(result);
        }
        return result;
    }

    @Override
    public void cleanUp() {
        this.removeVariableChangeListeners();
        this.clear();
    }

    @Override
    public Variables getClone() {
        Variables result;
        try {
            result = (Variables)this.getClass().newInstance();
            result.assign(this);
        }
        catch (Exception e) {
            result = null;
            System.err.println("Failed to clone variables:");
            e.printStackTrace();
        }
        return result;
    }

    public void assign(Variables other) {
        Enumeration<String> names = other.names();
        while (names.hasMoreElements()) {
            String name = names.nextElement();
            this.set(name, other.get(name));
        }
    }

    public String toString() {
        return this.m_Variables.toString();
    }
}

