/*
 * Decompiled with CFR 0.152.
 */
package adams.core.annotation;

import adams.core.io.FileUtils;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;

public abstract class AbstractCopyrightProcessor<T extends Annotation>
extends AbstractProcessor {
    protected boolean m_IsFirst = true;

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.RELEASE_6;
    }

    @Override
    public Set<String> getSupportedOptions() {
        return new HashSet<String>(Arrays.asList("module", "output", "printheader"));
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return new HashSet<String>(Arrays.asList(this.getAnnotationClass().getName()));
    }

    protected abstract Class getAnnotationClass();

    protected abstract String getOutputFile(String var1);

    protected abstract String getHeaderRow();

    protected abstract String getDataRow(T var1, String var2, String var3, String var4);

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Map<String, String> options = this.processingEnv.getOptions();
        String module = options.containsKey("module") ? options.get("module") : "N/A";
        boolean printHeader = options.get("printheader") != null && options.get("printheader").equalsIgnoreCase("true");
        String output = options.get("output");
        if (output != null) {
            output = this.getOutputFile(output);
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(this.getAnnotationClass())) {
            String method;
            String cls;
            Object copyright = element.getAnnotation(this.getAnnotationClass());
            if (element.getKind() == ElementKind.CLASS) {
                cls = ((Object)element.asType()).toString();
                method = "";
            } else {
                cls = ((Object)element.getEnclosingElement().asType()).toString();
                method = element.getSimpleName().toString();
            }
            String line = this.getDataRow(copyright, module, cls, method);
            if (output == null) {
                if (this.m_IsFirst && printHeader) {
                    System.out.println(this.getHeaderRow());
                }
                System.out.println(line);
            } else {
                if (this.m_IsFirst && printHeader) {
                    FileUtils.writeToFile(output, (Object)this.getHeaderRow(), false);
                }
                FileUtils.writeToFile(output, (Object)line, true);
            }
            this.m_IsFirst = false;
        }
        return true;
    }
}

