/*
 * Decompiled with CFR 0.152.
 */
package adams.core.base;

import adams.core.base.AbstractBaseString;
import adams.core.net.InternetHelper;

public class BasePassword
extends AbstractBaseString {
    private static final long serialVersionUID = -3626665478868498359L;
    public static final String BASE64_START = "{";
    public static final String BASE64_END = "}";
    public static final String ERROR = "-ERROR-";
    public static final String MASK_CHAR = "*";

    public BasePassword() {
        this("");
    }

    public BasePassword(String s) {
        super(s);
    }

    protected String decode(String base64) {
        String result = InternetHelper.decodeBase64(base64.substring(1, base64.length() - 1));
        if (result == null) {
            result = ERROR;
        }
        return result;
    }

    protected String encode(String raw) {
        return BASE64_START + InternetHelper.encodeBase64(raw) + BASE64_END;
    }

    @Override
    public boolean isValid(String value) {
        if (value.startsWith(BASE64_START)) {
            return value.endsWith(BASE64_END);
        }
        return true;
    }

    @Override
    public void setValue(String value) {
        if (!this.isValid(value)) {
            return;
        }
        this.m_Internal = value.startsWith(BASE64_START) ? this.decode(value) : value;
    }

    @Override
    public String getValue() {
        return (String)((Object)this.m_Internal);
    }

    public String getMaskedValue() {
        return this.getValue().replaceAll(".", MASK_CHAR);
    }

    @Override
    public String stringValue() {
        return this.encode(this.getValue());
    }

    @Override
    public String getTipText() {
        return "For handling passwords.";
    }
}

