/*
 * Decompiled with CFR 0.152.
 */
package adams.core.option;

import adams.core.Utils;
import adams.core.Variables;
import adams.core.option.AbstractOption;
import adams.core.option.OptionManager;
import adams.core.option.OptionUtils;
import adams.event.VariableChangeEvent;
import adams.event.VariableChangeListener;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;

public abstract class AbstractArgumentOption
extends AbstractOption
implements VariableChangeListener {
    private static final long serialVersionUID = 8495236290921805608L;
    protected Class m_BaseClass = null;
    protected boolean m_Multiple = false;
    protected String m_Variable = null;
    protected boolean m_VariableModified = false;
    protected Boolean m_VariableReferencesObject = null;

    protected AbstractArgumentOption(OptionManager owner, String commandline, String property, Object defValue) {
        this(owner, commandline, property, defValue, true);
    }

    protected AbstractArgumentOption(OptionManager owner, String commandline, String property, Object defValue, boolean outputDefValue) {
        super(owner, commandline, property, defValue, outputDefValue);
        if (this.getDescriptor() != null) {
            this.m_Multiple = this.getDescriptor().getReadMethod().getReturnType().isArray();
            this.m_BaseClass = this.isMultiple() ? this.getDescriptor().getPropertyType().getComponentType() : this.getDescriptor().getPropertyType();
        }
    }

    public boolean isMultiple() {
        return this.m_Multiple;
    }

    public boolean hasBaseClass() {
        return this.m_BaseClass != null;
    }

    public Class getBaseClass() {
        return this.m_BaseClass;
    }

    public boolean isVariableAttached() {
        return this.m_Variable != null;
    }

    public void setVariable(String value) {
        this.m_VariableReferencesObject = null;
        this.m_Variable = value != null ? Variables.extractName(value) : null;
    }

    public String getVariable() {
        if (this.m_Variable == null) {
            return null;
        }
        return Variables.padName(this.m_Variable);
    }

    public String getVariableName() {
        return this.m_Variable;
    }

    public boolean isVariableModified() {
        return this.isVariableAttached() && this.m_VariableModified;
    }

    public boolean isVariableReferencingObject() {
        if (this.m_Variable == null) {
            return false;
        }
        if (this.m_VariableReferencesObject == null) {
            this.m_VariableReferencesObject = this.getOwner().getVariables().isObject(this.m_Variable);
        }
        return this.m_VariableReferencesObject;
    }

    @Override
    public void variableChanged(VariableChangeEvent e) {
        if (!this.isVariableAttached()) {
            return;
        }
        if (e.getName().equals(this.getVariableName())) {
            this.m_VariableModified = true;
        }
    }

    public String updateVariable() {
        Method method = this.getWriteMethod();
        if (method == null) {
            System.err.println("Failed to obtain write method for option '" + this.getCommandline() + "/" + this.getProperty() + ", cannot set variable value ('" + this.m_Variable + "')!");
            return "Write method not found";
        }
        Variables vars = this.getOwner().getVariables();
        if (!vars.has(this.m_Variable)) {
            System.err.println("Variable '" + this.m_Variable + "' is not defined (" + this.getOwner().getVariables().hashCode() + ")!");
            return "Variable '" + this.m_Variable + "' not defined (" + this.getOwner().getVariables().hashCode() + ")";
        }
        Object value = vars.isObject(this.m_Variable) ? vars.getObject(this.m_Variable) : vars.get(this.m_Variable);
        if (value == null) {
            System.err.println("Variable '" + this.m_Variable + "' has no value associated!");
            return "Variable '" + this.m_Variable + "' has no value associated";
        }
        if (vars.isObject(this.m_Variable)) {
            try {
                method.invoke((Object)this.getOptionHandler(), value);
                this.m_VariableModified = false;
                return null;
            }
            catch (Exception e) {
                System.err.println("Failed to set value for variable '" + this.m_Variable + "' (" + value.getClass().getName() + "): " + value);
                e.printStackTrace();
                System.err.println("Wrong class? Attempting to set value using string representation instead!");
                value = vars.get(this.m_Variable);
            }
        }
        try {
            if (this.isMultiple()) {
                String[] values = OptionUtils.splitOptions((String)value);
                Object objects = Array.newInstance(this.getBaseClass(), values.length);
                for (int i = 0; i < values.length; ++i) {
                    Array.set(objects, i, this.valueOf(values[i]));
                }
                value = objects;
            } else {
                value = this.valueOf((String)value);
            }
            method.invoke((Object)this.getOptionHandler(), value);
            this.m_VariableModified = false;
        }
        catch (Exception e) {
            System.err.println("Failed to set value for variable '" + this.m_Variable + "' (" + Utils.getArrayClass(value.getClass()) + "): " + value);
            e.printStackTrace();
            return "Failed to set value for variable '" + this.m_Variable + "'";
        }
        return null;
    }

    public abstract Object valueOf(String var1) throws Exception;

    public abstract String toString(Object var1);

    protected abstract boolean compareValues(Object var1, Object var2);

    protected boolean isDefaultValue(Object value) {
        boolean result;
        if (!OptionUtils.getSuppressDefaultValues()) {
            result = false;
        } else {
            result = true;
            if (this.isMultiple()) {
                boolean bl = result = Array.getLength(value) == Array.getLength(this.getDefaultValue());
                if (result) {
                    int len = Array.getLength(value);
                    for (int i = 0; i < len && (result = this.compareValues(Array.get(value, i), Array.get(this.getDefaultValue(), i))); ++i) {
                    }
                }
            } else {
                result = this.compareValues(value, this.getDefaultValue());
            }
        }
        return result;
    }

    public String[] toArray() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.isVariableAttached()) {
            result.add("-" + this.getCommandline());
            result.add(this.getVariable());
        } else {
            Object currValue = this.getCurrentValue();
            if (!this.isDefaultValue(currValue)) {
                Object currValues = null;
                if (currValue != null) {
                    if (!this.isMultiple()) {
                        currValues = Array.newInstance(this.getBaseClass(), 1);
                        Array.set(currValues, 0, currValue);
                    } else {
                        currValues = currValue;
                    }
                    for (int i = 0; i < Array.getLength(currValues); ++i) {
                        result.add("-" + this.getCommandline());
                        result.add(this.toString(Array.get(currValues, i)));
                    }
                }
            }
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public void cleanUp() {
        if (this.getOwner() != null && this.getOwner().getVariables() != null) {
            this.getOwner().getVariables().removeVariableChangeListener(this);
        }
        this.m_BaseClass = null;
        super.cleanUp();
    }

    public String toString() {
        return "-" + this.getCommandline() + "/" + this.getProperty() + " <arg>" + (this.isMultiple() ? " ..." : "");
    }
}

