/*
 * Decompiled with CFR 0.152.
 */
package adams.core.option;

import adams.core.logging.LoggingLevel;
import adams.core.logging.LoggingObject;
import adams.core.option.OptionHandler;
import adams.core.option.OptionManager;
import adams.core.option.OptionUtils;

public abstract class AbstractOptionHandler
extends LoggingObject
implements OptionHandler {
    private static final long serialVersionUID = -4086279255884465893L;
    protected OptionManager m_OptionManager;

    public AbstractOptionHandler() {
        this.initialize();
        this.defineOptions();
        this.getOptionManager().setDefaults();
        this.finishInit();
    }

    public abstract String globalInfo();

    protected void initialize() {
    }

    protected void reset() {
    }

    protected OptionManager newOptionManager() {
        return new OptionManager(this);
    }

    @Override
    public void defineOptions() {
        this.m_OptionManager = this.newOptionManager();
        this.m_OptionManager.add("logging-level", "loggingLevel", (Object)this.getDefaultLoggingLevel());
    }

    protected void finishInit() {
        this.configureLogger();
    }

    @Override
    public OptionManager getOptionManager() {
        if (this.m_OptionManager == null) {
            this.defineOptions();
        }
        return this.m_OptionManager;
    }

    @Override
    public void cleanUpOptions() {
        if (this.m_OptionManager != null) {
            this.m_OptionManager.cleanUp();
            this.m_OptionManager = null;
        }
    }

    @Override
    public void destroy() {
        this.cleanUpOptions();
    }

    protected LoggingLevel getDefaultLoggingLevel() {
        return LoggingLevel.WARNING;
    }

    public synchronized void setLoggingLevel(LoggingLevel value) {
        this.m_LoggingLevel = value;
        this.m_Logger = null;
        this.reset();
    }

    public String loggingLevelTipText() {
        return "The logging level for outputting errors and debugging output.";
    }

    public String toString() {
        return OptionUtils.getCommandLine(this);
    }

    public String toCommandLine() {
        return OptionUtils.getCommandLine(this);
    }
}

