/*
 * Decompiled with CFR 0.152.
 */
package adams.core.option;

import adams.core.ClassLocator;
import adams.core.VariablesHandler;
import adams.core.option.AbstractArgumentOption;
import adams.core.option.AbstractOption;
import adams.core.option.AbstractOptionHandler;
import adams.core.option.BooleanOption;
import adams.core.option.ClassOption;
import adams.core.option.OptionTraversalPath;
import adams.core.option.OptionTraverserWithResult;
import java.io.File;
import java.lang.reflect.Array;

public class FileLister
extends AbstractOptionHandler
implements OptionTraverserWithResult<String> {
    private static final long serialVersionUID = -6561961647781822476L;
    protected StringBuilder m_Result;

    @Override
    public String globalInfo() {
        return "Lists all file objects.";
    }

    @Override
    protected void reset() {
        super.reset();
        this.resetResult();
    }

    @Override
    public void resetResult() {
        this.m_Result = new StringBuilder();
        this.m_Result.append("Path");
        this.m_Result.append("\t");
        this.m_Result.append("Class");
        this.m_Result.append("\t");
        this.m_Result.append("Property");
        this.m_Result.append("\t");
        this.m_Result.append("File");
        this.m_Result.append("\n");
    }

    @Override
    public void handleBooleanOption(BooleanOption option, OptionTraversalPath path) {
    }

    @Override
    public void handleClassOption(ClassOption option, OptionTraversalPath path) {
    }

    @Override
    public void handleArgumentOption(AbstractArgumentOption option, OptionTraversalPath path) {
        if (ClassLocator.isSubclass(File.class, option.getBaseClass())) {
            if (option.isMultiple()) {
                Object array = option.getCurrentValue();
                for (int i = 0; i < Array.getLength(array); ++i) {
                    this.m_Result.append(path.getPath());
                    this.m_Result.append("\t");
                    this.m_Result.append(option.getOptionHandler().getClass().getName());
                    this.m_Result.append("\t");
                    this.m_Result.append(option.getProperty() + "[" + i + "]");
                    this.m_Result.append("\t");
                    this.m_Result.append(option.getCurrentValue());
                    this.m_Result.append("\n");
                }
            } else {
                this.m_Result.append(path.getPath());
                this.m_Result.append("\t");
                this.m_Result.append(option.getOptionHandler().getClass().getName());
                this.m_Result.append("\t");
                this.m_Result.append(option.getProperty());
                this.m_Result.append("\t");
                this.m_Result.append(option.getCurrentValue());
                this.m_Result.append("\n");
            }
        }
    }

    @Override
    public boolean canHandle(AbstractOption option) {
        return true;
    }

    @Override
    public boolean canRecurse(Class cls) {
        return !ClassLocator.hasInterface(VariablesHandler.class, cls);
    }

    @Override
    public boolean canRecurse(Object obj) {
        return this.canRecurse(obj.getClass());
    }

    @Override
    public String getResult() {
        return this.m_Result.toString();
    }
}

