/*
 * Decompiled with CFR 0.152.
 */
package adams.core.option;

import adams.core.Utils;
import adams.core.Variables;
import adams.core.io.FileFormatHandler;
import adams.core.option.AbstractArgumentOption;
import adams.core.option.AbstractOption;
import adams.core.option.AbstractRecursiveOptionConsumer;
import adams.core.option.BooleanOption;
import adams.core.option.ClassOption;
import adams.core.option.Conversion;
import adams.core.option.OptionHandler;
import adams.core.option.OptionManager;
import adams.core.option.OptionUtils;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.logging.Level;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import net.minidev.json.parser.JSONParser;

public class JsonConsumer
extends AbstractRecursiveOptionConsumer<JSONObject, Object>
implements FileFormatHandler {
    private static final long serialVersionUID = -840227436726154503L;
    public static final String KEY_CLASS = "class";
    public static final String KEY_OPTIONS = "options";

    @Override
    public String globalInfo() {
        return "Processes JSON (JavaScript Object Notation) input.\n\nFor more information on JSON, see:\nhttp://json.org/";
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_UsePropertyNames = true;
    }

    @Override
    protected OptionHandler initOutput() {
        OptionHandler result = null;
        if (((JSONObject)this.m_Input).containsKey((Object)KEY_CLASS)) {
            try {
                result = (OptionHandler)Class.forName(Conversion.rename((String)((JSONObject)this.m_Input).get((Object)KEY_CLASS))).newInstance();
            }
            catch (Exception e) {
                String msg = "Failed to instantiate class: ";
                this.getLogger().log(Level.SEVERE, msg, e);
                this.logError(msg + e);
            }
        } else {
            this.logError("Key 'class' not present!");
        }
        return result;
    }

    @Override
    protected void processOption(BooleanOption option, Object values) throws Exception {
        Method method = this.getWriteMethod(option);
        if (method == null) {
            return;
        }
        if (Array.getLength(values) != 1) {
            String msg = "No value available for option '" + option.getProperty() + "'?";
            this.getLogger().log(Level.SEVERE, msg);
            this.logError(msg);
            return;
        }
        Boolean param = (Boolean)Array.get(values, 0);
        method.invoke((Object)option.getOptionHandler(), param);
    }

    @Override
    protected void processOption(ClassOption option, Object values) throws Exception {
        Object objects;
        Method method = this.getWriteMethod(option);
        if (method == null) {
            return;
        }
        if (Array.getLength(values) != 1) {
            String msg = "No value available for option '" + option.getProperty() + "'?";
            this.getLogger().log(Level.SEVERE, msg);
            this.logError(msg);
            return;
        }
        Object value = Array.get(values, 0);
        if (value instanceof String && Variables.isPlaceholder((String)value)) {
            option.setVariable((String)value);
            return;
        }
        if (value instanceof JSONObject) {
            JSONObject object = (JSONObject)value;
            objects = Array.newInstance(option.getBaseClass(), 1);
            Object obj = Class.forName((String)object.get((Object)KEY_CLASS)).newInstance();
            if (obj instanceof OptionHandler) {
                OptionHandler handler = (OptionHandler)obj;
                Array.set(objects, 0, handler);
                this.checkDeprecation(handler);
                this.doConsume(handler.getOptionManager(), object);
            } else {
                String[] strOptions = (String[])((JSONArray)object.get((Object)KEY_OPTIONS)).toArray((Object[])new String[0]);
                obj = OptionUtils.forName(Object.class, obj.getClass().getName(), strOptions);
                Array.set(objects, 0, obj);
            }
        } else if (value instanceof JSONArray) {
            JSONArray array = (JSONArray)value;
            objects = Array.newInstance(option.getBaseClass(), array.size());
            for (int i = 0; i < array.size(); ++i) {
                JSONObject object = (JSONObject)array.get(i);
                Object obj = Class.forName((String)object.get((Object)KEY_CLASS)).newInstance();
                if (obj instanceof OptionHandler) {
                    OptionHandler handler = (OptionHandler)obj;
                    Array.set(objects, i, handler);
                    this.checkDeprecation(handler);
                    this.doConsume(handler.getOptionManager(), object);
                    continue;
                }
                String[] strOptions = (String[])((JSONArray)object.get((Object)KEY_OPTIONS)).toArray((Object[])new String[0]);
                obj = OptionUtils.forName(Object.class, obj.getClass().getName(), strOptions);
                Array.set(objects, i, obj);
            }
        } else {
            String msg = "Unhandled JSON type: " + value.getClass().getName();
            this.getLogger().log(Level.SEVERE, msg);
            this.logError(msg);
            return;
        }
        if (!option.isMultiple()) {
            method.invoke((Object)option.getOptionHandler(), Array.get(objects, 0));
        } else {
            method.invoke((Object)option.getOptionHandler(), objects);
        }
    }

    @Override
    protected void processOption(AbstractArgumentOption option, Object values) throws Exception {
        Object objects;
        Method method = this.getWriteMethod(option);
        if (method == null) {
            return;
        }
        if (Array.getLength(values) != 1) {
            String msg = "No value available for option '" + option.getProperty() + "'?";
            this.getLogger().log(Level.SEVERE, msg);
            this.logError(msg);
            return;
        }
        Object value = Array.get(values, 0);
        if (value instanceof String && Variables.isPlaceholder((String)value)) {
            option.setVariable((String)value);
            return;
        }
        if (value instanceof JSONArray) {
            JSONArray array = (JSONArray)value;
            objects = Array.newInstance(option.getBaseClass(), array.size());
            for (int i = 0; i < array.size(); ++i) {
                Array.set(objects, i, option.valueOf(array.get(i).toString()));
            }
        } else {
            objects = Array.newInstance(option.getBaseClass(), 1);
            Array.set(objects, 0, option.valueOf(value.toString()));
        }
        if (!option.isMultiple()) {
            method.invoke((Object)option.getOptionHandler(), Array.get(objects, 0));
        } else {
            method.invoke((Object)option.getOptionHandler(), objects);
        }
    }

    protected Object[] collectValues(AbstractOption option, JSONObject input) {
        ArrayList<Object> result = new ArrayList<Object>();
        String optionStr = this.getOptionIdentifier(option);
        for (String name : input.keySet()) {
            if (!name.equals(optionStr)) continue;
            result.add(input.get((Object)name));
        }
        return result.toArray(new Object[result.size()]);
    }

    @Override
    protected void doConsume(OptionManager manager, JSONObject input) {
        for (String name : input.keySet()) {
            String msg;
            if (name.equals(KEY_CLASS) || name.equals(KEY_OPTIONS)) continue;
            AbstractOption option = manager.findByProperty(name);
            if (option == null) {
                msg = "Failed to find option (" + manager.getOwner().getClass().getName() + "): " + name;
                this.logWarning(msg);
                this.getLogger().log(Level.SEVERE, msg);
                continue;
            }
            Object[] values = this.collectValues(option, input);
            if (option instanceof AbstractArgumentOption && values.length == 0) {
                msg = "No argument supplied for option '" + option + "' (" + manager.getOwner().getClass().getName() + ")!";
                this.logWarning(msg);
                this.getLogger().log(Level.SEVERE, msg);
            }
            try {
                this.processOption(option, values);
            }
            catch (Exception e) {
                msg = "Failed to process option '" + this.getOptionIdentifier(option) + "/" + manager.getOwner().getClass().getName() + "':";
                this.logError(msg + " " + Utils.throwableToString(e));
                this.getLogger().log(Level.SEVERE, msg, e);
            }
        }
    }

    @Override
    protected JSONObject convertToInput(String s) {
        JSONObject result = new JSONObject();
        try {
            JSONParser tokener = new JSONParser(448);
            result = (JSONObject)tokener.parse(s);
        }
        catch (Exception e) {
            String msg = "Failed to parse JSON string: ";
            this.getLogger().log(Level.SEVERE, msg, e);
            this.logError(msg + e);
        }
        return result;
    }

    @Override
    public String getFormatDescription() {
        return "JSON";
    }

    @Override
    public String getDefaultFormatExtension() {
        return "json";
    }

    @Override
    public String[] getFormatExtensions() {
        return new String[]{this.getDefaultFormatExtension()};
    }
}

