/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.base.BaseDateTime;
import adams.data.conversion.AbstractConversionToString;

public class BaseDateTimeToString
extends AbstractConversionToString {
    private static final long serialVersionUID = 6744245717394758406L;
    protected BaseDateTime m_Start;
    protected BaseDateTime m_End;

    @Override
    public String globalInfo() {
        return "Turns a BaseDateTime format string into a String, evaluted using user-supplied start and end dates (ignored if future INF dates).";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("start", "start", new BaseDateTime("-INF"));
        this.m_OptionManager.add("end", "end", new BaseDateTime("+INF"));
    }

    public void setStart(BaseDateTime value) {
        this.m_Start = value;
        this.reset();
    }

    public BaseDateTime getStart() {
        return this.m_Start;
    }

    public String startTipText() {
        return "The start date to use in the evaluation.";
    }

    public void setEnd(BaseDateTime value) {
        this.m_End = value;
        this.reset();
    }

    public BaseDateTime getEnd() {
        return this.m_End;
    }

    public String endTipText() {
        return "The end date to use in the evaluation.";
    }

    @Override
    public Class accepts() {
        return String.class;
    }

    @Override
    protected Object doConvert() throws Exception {
        BaseDateTime result = new BaseDateTime((String)this.m_Input);
        if (!this.m_Start.isInfinity()) {
            result.setStart(this.m_Start.dateValue());
        }
        if (!this.m_End.isInfinity()) {
            result.setEnd(this.m_End.dateValue());
        }
        return result.stringValue();
    }
}

