/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.management.LocaleHelper;
import adams.core.management.OptionHandlingLocaleSupporter;
import adams.core.option.OptionHandler;
import adams.data.conversion.AbstractConversionToString;
import java.util.Locale;

public class DoubleToString
extends AbstractConversionToString
implements OptionHandlingLocaleSupporter {
    private static final long serialVersionUID = -9142177169642814841L;
    protected Locale m_Locale;
    protected int m_NumDecimals;
    protected boolean m_FixedDecimals;

    @Override
    public String globalInfo() {
        return "Turns a Double into a String.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("locale", "locale", LocaleHelper.getSingleton().getDefault());
        this.m_OptionManager.add("num-decimals", "numDecimals", -1, -1, null);
        this.m_OptionManager.add("fixed-decimals", "fixedDecimals", false);
    }

    @Override
    public void setLocale(Locale value) {
        this.m_Locale = value;
        this.reset();
    }

    @Override
    public Locale getLocale() {
        return this.m_Locale;
    }

    @Override
    public String localeTipText() {
        return "The locale to use for formatting the numbers.";
    }

    public void setNumDecimals(int value) {
        if (value >= 0 || value == -1) {
            this.m_NumDecimals = value;
            this.reset();
        } else {
            System.err.println("Number of decimals cannot be negative!");
        }
    }

    public int getNumDecimals() {
        return this.m_NumDecimals;
    }

    public String numDecimalsTipText() {
        return "The number of decimals for numeric values to use; -1 uses Java's Double.toString() method.";
    }

    public void setFixedDecimals(boolean value) {
        this.m_FixedDecimals = value;
        this.reset();
    }

    public boolean getFixedDecimals() {
        return this.m_FixedDecimals;
    }

    public String fixedDecimalsTipText() {
        return "If enabled and 'num-decimals' is specified, a fixed number of decimals will get output (incl. trailing zeroes), otherwise up-to 'num-decimals'.";
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, "locale", this.m_Locale, null);
        result = result + QuickInfoHelper.toString((OptionHandler)this, "numDecimals", this.m_NumDecimals, ", decimals: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, "fixedDeciumals", this.m_FixedDecimals, "fixed", ", ");
        return result;
    }

    @Override
    public Class accepts() {
        return Double.class;
    }

    @Override
    protected Object doConvert() throws Exception {
        if (this.m_NumDecimals == -1) {
            return LocaleHelper.getSingleton().getNumberFormat(this.m_Locale).format((Double)this.m_Input);
        }
        if (this.m_FixedDecimals) {
            return Utils.doubleToStringFixed((Double)this.m_Input, this.m_NumDecimals, this.m_Locale);
        }
        return Utils.doubleToString((double)((Double)this.m_Input), this.m_NumDecimals, this.m_Locale);
    }
}

