/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.RoundingType;
import adams.data.conversion.AbstractConversion;

public class Round
extends AbstractConversion {
    private static final long serialVersionUID = -4941255219517637632L;
    protected RoundingType m_Action;

    @Override
    public String globalInfo() {
        return "Rounds double values and turns them into integers..";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("action", "action", (Object)RoundingType.ROUND);
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, "action", (Object)this.m_Action);
    }

    public void setAction(RoundingType value) {
        this.m_Action = value;
        this.reset();
    }

    public RoundingType getAction() {
        return this.m_Action;
    }

    public String actionTipText() {
        return "The action to perform on the doubles passing through.";
    }

    @Override
    public Class accepts() {
        return Double.class;
    }

    @Override
    public Class generates() {
        return Integer.class;
    }

    @Override
    protected Object doConvert() throws Exception {
        Double input = (Double)this.m_Input;
        switch (this.m_Action) {
            case ROUND: {
                return (int)Math.round(input);
            }
            case CEILING: {
                return (int)Math.ceil(input);
            }
            case FLOOR: {
                return (int)Math.floor(input);
            }
        }
        throw new IllegalStateException("Unhandled action: " + (Object)((Object)this.m_Action));
    }
}

