/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.output;

import adams.core.ClassLister;
import adams.core.io.FileEncodingSupporter;
import adams.core.option.AbstractOptionHandler;
import adams.data.io.output.AppendableSpreadSheetWriter;
import adams.data.io.output.SpreadSheetWriter;
import adams.data.spreadsheet.SpreadSheet;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.commons.io.output.WriterOutputStream;
import org.codehaus.plexus.util.FileUtils;

public abstract class AbstractSpreadSheetWriter
extends AbstractOptionHandler
implements SpreadSheetWriter,
FileEncodingSupporter {
    private static final long serialVersionUID = -3547064795252689769L;
    protected String m_Encoding;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Encoding = "";
    }

    @Override
    public abstract String getFormatDescription();

    @Override
    public abstract String[] getFormatExtensions();

    public String getDefaultFormatExtension() {
        return this.getFormatExtensions()[0];
    }

    @Override
    public void setEncoding(String value) {
        this.m_Encoding = value;
        this.reset();
    }

    @Override
    public String getEncoding() {
        return this.m_Encoding;
    }

    @Override
    public String encodingTipText() {
        return "The type of encoding to use when writing using a writer, use empty string for default.";
    }

    protected abstract boolean getUseOutputStream();

    @Override
    public boolean write(SpreadSheet content, File file) {
        return this.write(content, file.getAbsolutePath());
    }

    @Override
    public boolean write(SpreadSheet content, String filename) {
        boolean result = true;
        boolean append = false;
        if (this instanceof AppendableSpreadSheetWriter) {
            AppendableSpreadSheetWriter appendable = (AppendableSpreadSheetWriter)((Object)this);
            appendable.setFileExists(FileUtils.fileExists((String)filename));
            append = appendable.canAppend(content);
        }
        try {
            if (this.getUseOutputStream()) {
                FileOutputStream output = new FileOutputStream(filename, append);
                result = this.doWrite(content, output);
                ((OutputStream)output).close();
            } else {
                BufferedWriter writer = this.m_Encoding != null && this.m_Encoding.length() > 0 ? new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename, append), this.m_Encoding)) : new BufferedWriter(new OutputStreamWriter(new FileOutputStream(filename, append)));
                result = this.doWrite(content, writer);
                writer.close();
            }
        }
        catch (Exception e) {
            result = false;
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public boolean write(SpreadSheet content, OutputStream stream) {
        if (this.getUseOutputStream()) {
            return this.doWrite(content, stream);
        }
        return this.doWrite(content, new OutputStreamWriter(stream));
    }

    @Override
    public boolean write(SpreadSheet content, Writer writer) {
        if (this.getUseOutputStream()) {
            return this.doWrite(content, (OutputStream)new WriterOutputStream(writer));
        }
        return this.doWrite(content, writer);
    }

    protected boolean doWrite(SpreadSheet content, Writer writer) {
        return false;
    }

    protected boolean doWrite(SpreadSheet content, OutputStream out) {
        return false;
    }

    public static String[] getWriters() {
        return ClassLister.getSingleton().getClassnames(SpreadSheetWriter.class);
    }
}

