/*
 * Decompiled with CFR 0.152.
 */
package adams.data.sequence;

import adams.data.container.AbstractDataContainer;
import adams.data.container.DataPointComparator;
import adams.data.sequence.XYSequencePoint;
import adams.data.sequence.XYSequencePointComparator;
import adams.data.sequence.XYSequenceUtils;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetSupporter;
import gnu.trove.list.array.TDoubleArrayList;
import gnu.trove.map.hash.TDoubleObjectHashMap;
import java.util.ArrayList;
import java.util.List;

public class XYSequence
extends AbstractDataContainer<XYSequencePoint>
implements SpreadSheetSupporter {
    private static final long serialVersionUID = -3742507986126404535L;
    public static final String FILE_EXTENSION = ".csv";
    protected DataPointComparator m_Comparator;
    protected XYSequencePointComparator.Comparison m_Comparison;
    protected XYSequencePoint m_MinX;
    protected XYSequencePoint m_MaxX;
    protected XYSequencePoint m_MinY;
    protected XYSequencePoint m_MaxY;
    protected TDoubleObjectHashMap<String> m_MappingX = null;
    protected TDoubleObjectHashMap<String> m_MappingY = null;

    public XYSequence() {
        this.invalidateMinMax();
        this.setComparison(XYSequencePointComparator.Comparison.X);
    }

    public void assign(XYSequence other) {
        super.assign(other);
        if (other.m_MappingX != null) {
            this.m_MappingX = new TDoubleObjectHashMap(other.m_MappingX);
        }
        if (other.m_MappingY != null) {
            this.m_MappingY = new TDoubleObjectHashMap(other.m_MappingY);
        }
    }

    public boolean hasMappingX() {
        return this.m_MappingX != null;
    }

    public double putMappingX(String s) {
        if (this.m_MappingX == null) {
            this.m_MappingX = new TDoubleObjectHashMap();
        }
        double result = this.m_MappingX.size() + 1;
        this.m_MappingX.put(result, (Object)s);
        return result;
    }

    public String removeMappingX(double x) {
        if (this.m_MappingX == null) {
            return null;
        }
        return (String)this.m_MappingX.remove(x);
    }

    public String getMappingX(double key) {
        return (String)this.m_MappingX.get(key);
    }

    public List<String> getLabelsX() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.m_MappingX == null) {
            return result;
        }
        TDoubleArrayList index = new TDoubleArrayList(this.m_MappingX.keys());
        index.sort();
        for (int i = 0; i < index.size(); ++i) {
            result.add((String)this.m_MappingX.get(index.get(i)));
        }
        return result;
    }

    public TDoubleObjectHashMap<String> getMappingsX() {
        return this.m_MappingX;
    }

    public boolean hasMappingY() {
        return this.m_MappingY != null;
    }

    public double putMappingY(String s) {
        if (this.m_MappingY == null) {
            this.m_MappingY = new TDoubleObjectHashMap();
        }
        double result = this.m_MappingY.size() + 1;
        this.m_MappingY.put(result, (Object)s);
        return result;
    }

    public String removeMappingY(double y) {
        if (this.m_MappingY == null) {
            return null;
        }
        return (String)this.m_MappingY.remove(y);
    }

    public String getMappingY(double key) {
        return (String)this.m_MappingY.get(key);
    }

    public List<String> getLabelsY() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.m_MappingY == null) {
            return result;
        }
        TDoubleArrayList index = new TDoubleArrayList(this.m_MappingY.keys());
        index.sort();
        for (int i = 0; i < index.size(); ++i) {
            result.add((String)this.m_MappingY.get(index.get(i)));
        }
        return result;
    }

    public TDoubleObjectHashMap<String> getMappingsY() {
        return this.m_MappingY;
    }

    public void setComparison(XYSequencePointComparator.Comparison value) {
        this.m_Comparison = value;
        this.m_Comparator = this.newComparator();
    }

    public XYSequencePointComparator.Comparison getComparison() {
        return this.m_Comparison;
    }

    @Override
    public DataPointComparator<XYSequencePoint> newComparator() {
        return new XYSequencePointComparator(this.m_Comparison, true);
    }

    @Override
    public DataPointComparator<XYSequencePoint> getComparator() {
        return this.m_Comparator;
    }

    @Override
    public XYSequencePoint newPoint() {
        return new XYSequencePoint();
    }

    @Override
    protected boolean modifiedListener(boolean modified) {
        this.invalidateMinMax();
        return modified;
    }

    protected void invalidateMinMax() {
        this.m_MinX = null;
        this.m_MaxX = null;
        this.m_MinY = null;
        this.m_MaxY = null;
    }

    protected synchronized void validateMinMax() {
        if (this.m_MinX != null) {
            return;
        }
        for (XYSequencePoint point : this) {
            if (this.m_MinX == null || point.getX() < this.m_MinX.getX()) {
                this.m_MinX = point;
            }
            if (this.m_MaxX == null || point.getX() > this.m_MaxX.getX()) {
                this.m_MaxX = point;
            }
            if (this.m_MinY == null || point.getY() < this.m_MinY.getY()) {
                this.m_MinY = point;
            }
            if (this.m_MaxY != null && !(point.getY() > this.m_MaxY.getY())) continue;
            this.m_MaxY = point;
        }
    }

    public XYSequencePoint getMinX() {
        this.validateMinMax();
        return this.m_MinX;
    }

    public XYSequencePoint getMaxX() {
        this.validateMinMax();
        return this.m_MaxX;
    }

    public XYSequencePoint getMinY() {
        this.validateMinMax();
        return this.m_MinY;
    }

    public XYSequencePoint getMaxY() {
        this.validateMinMax();
        return this.m_MaxY;
    }

    public XYSequencePoint find(double x) {
        XYSequencePoint result = null;
        ArrayList<XYSequencePoint> points = new ArrayList<XYSequencePoint>(this.m_Points);
        int index = XYSequenceUtils.findX(points, x);
        if (index > -1) {
            result = (XYSequencePoint)this.m_Points.get(index);
        }
        return result;
    }

    public XYSequencePoint findClosest(double x) {
        XYSequencePoint result = null;
        ArrayList<XYSequencePoint> points = new ArrayList<XYSequencePoint>(this.m_Points);
        int index = XYSequenceUtils.findClosestX(points, x);
        if (index > -1) {
            result = (XYSequencePoint)this.m_Points.get(index);
        }
        return result;
    }

    @Override
    public SpreadSheet toSpreadSheet() {
        SpreadSheet result = new SpreadSheet();
        result.setName(this.getID());
        Row row = result.getHeaderRow();
        row.addCell("ID").setContent("ID");
        row.addCell("X").setContent("X");
        row.addCell("Y").setContent("Y");
        for (XYSequencePoint point : this) {
            row = result.addRow();
            row.addCell("ID").setContent(point.getID());
            if (this.hasMappingX()) {
                row.addCell("X").setContent(this.getMappingX(point.getX()));
            } else {
                row.addCell("X").setContent(point.getX());
            }
            if (this.hasMappingY()) {
                row.addCell("Y").setContent(this.getMappingY(point.getY()));
                continue;
            }
            row.addCell("Y").setContent(point.getY());
        }
        return result;
    }
}

