/*
 * Decompiled with CFR 0.152.
 */
package adams.data.smoothing;

import adams.data.container.DataContainer;
import adams.data.container.DataPoint;
import adams.data.smoothing.AbstractSmoother;
import adams.data.statistics.StatUtils;
import java.util.List;

public abstract class AbstractSlidingWindow<T extends DataContainer>
extends AbstractSmoother<T> {
    private static final long serialVersionUID = 4528493242259502282L;
    protected int m_WindowSize;
    protected Measure m_Measure;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("window", "windowSize", 20);
        this.m_OptionManager.add("measure", "measure", (Object)Measure.MEDIAN);
    }

    public void setWindowSize(int value) {
        if (value > 0) {
            this.m_WindowSize = value;
            this.reset();
        } else {
            this.getLogger().severe(this.getClass().getName() + ".windowSize: only positive numbers are allowed for window size!");
        }
    }

    public int getWindowSize() {
        return this.m_WindowSize;
    }

    public String windowSizeTipText() {
        return "The window size for determining the 'smoothed' abundances.";
    }

    public void setMeasure(Measure value) {
        this.m_Measure = value;
        this.reset();
    }

    public Measure getMeasure() {
        return this.m_Measure;
    }

    public String measureTipText() {
        return "The measure to use for calculating the 'smoothed' abundances.";
    }

    protected abstract Double getValue(DataPoint var1);

    protected abstract void updatePoint(DataPoint var1, double var2);

    @Override
    protected T processData(T data) {
        DataPoint point;
        double measure;
        int n;
        int pos;
        DataContainer result = data.getHeader();
        List points = data.toList();
        Number[] abundances = new Double[this.m_WindowSize];
        int left = pos = this.m_WindowSize / 2;
        int right = this.m_WindowSize - left;
        for (int i = 0; i < points.size() - this.m_WindowSize + 1; ++i) {
            for (n = 0; n < this.m_WindowSize; ++n) {
                abundances[n] = this.getValue((DataPoint)points.get(i + n));
            }
            if (this.m_Measure == Measure.MEDIAN) {
                measure = (float)StatUtils.median(abundances);
            } else if (this.m_Measure == Measure.MEAN) {
                measure = (float)StatUtils.mean(abundances);
            } else {
                throw new IllegalStateException("Unhandled measure: " + (Object)((Object)this.m_Measure));
            }
            point = (DataPoint)((DataPoint)points.get(i + pos)).getClone();
            this.updatePoint(point, measure);
            result.add(point);
        }
        measure = this.getValue((DataPoint)result.toList().get(0));
        for (n = 0; n < left; ++n) {
            point = (DataPoint)((DataPoint)points.get(n)).getClone();
            this.updatePoint(point, measure);
            result.add(point);
        }
        measure = this.getValue((DataPoint)result.toList().get(result.toList().size() - 1));
        for (n = 0; n < right; ++n) {
            point = (DataPoint)((DataPoint)points.get(points.size() - this.m_WindowSize + pos + n)).getClone();
            this.updatePoint(point, measure);
            result.add(point);
        }
        return (T)result;
    }

    public static enum Measure {
        MEDIAN,
        MEAN;

    }
}

