/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spreadsheet;

import adams.core.ClassLister;
import adams.core.option.AbstractOptionHandler;
import java.util.HashMap;
import java.util.HashSet;

public abstract class AbstractObjectHandler<T>
extends AbstractOptionHandler {
    private static final long serialVersionUID = -3675851527684921384L;
    protected static HashMap<Class, Class> m_Handlers = new HashMap();
    protected static HashSet<Class> m_NoHandlers = new HashSet();

    public boolean handles(Object obj) {
        return this.handles(obj.getClass());
    }

    public abstract boolean handles(Class var1);

    public abstract T parse(String var1);

    public abstract String format(T var1);

    public static AbstractObjectHandler getHandler(Object obj) {
        return AbstractObjectHandler.getHandler(obj.getClass());
    }

    public static AbstractObjectHandler getHandler(Class cls) {
        AbstractObjectHandler result = null;
        if (m_NoHandlers.contains(cls)) {
            return result;
        }
        if (m_Handlers.containsKey(cls)) {
            try {
                result = (AbstractObjectHandler)m_Handlers.get(cls).newInstance();
            }
            catch (Exception e) {
                System.err.println("Failed to instantiate handler: " + m_Handlers.get(cls).getName());
                e.printStackTrace();
            }
        } else {
            String[] handlers;
            for (String h : handlers = AbstractObjectHandler.getHandlers()) {
                try {
                    AbstractObjectHandler handler = (AbstractObjectHandler)Class.forName(h).newInstance();
                    if (!handler.handles(cls)) continue;
                    m_Handlers.put(cls, handler.getClass());
                    result = handler;
                }
                catch (Exception e) {
                    System.err.println("Failed to process handler: " + h);
                    e.printStackTrace();
                }
            }
        }
        if (result == null) {
            m_NoHandlers.add(cls);
        }
        return result;
    }

    public static String[] getHandlers() {
        return ClassLister.getSingleton().getClassnames(AbstractObjectHandler.class);
    }
}

