/*
 * Decompiled with CFR 0.152.
 */
package adams.data.statistics;

import adams.data.statistics.AbstractArrayStatistic;
import adams.data.statistics.StatUtils;

public class ArraySum<T extends Number>
extends AbstractArrayStatistic<T> {
    private static final long serialVersionUID = -6084843255589216290L;

    @Override
    public String globalInfo() {
        return "Determines the sum of all values in a numeric array.";
    }

    @Override
    public int getMin() {
        return 1;
    }

    @Override
    public int getMax() {
        return -1;
    }

    @Override
    protected AbstractArrayStatistic.StatisticContainer doCalculate() {
        AbstractArrayStatistic.StatisticContainer<Double> result = new AbstractArrayStatistic.StatisticContainer<Double>(1, this.size());
        String prefix = "sum";
        if (this.size() > 1) {
            prefix = prefix + "-";
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.size() > 1) {
                result.setHeader(i, prefix + (i + 1));
            } else {
                result.setHeader(i, prefix);
            }
            result.setCell(0, i, StatUtils.sum((Number[])this.get(i)));
        }
        return result;
    }
}

