/*
 * Decompiled with CFR 0.152.
 */
package adams.data.utils;

import adams.core.logging.LoggingHelper;
import adams.gui.core.Point2DComparator;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;

public class LOWESS {
    protected static Point2DComparator m_Comparator = new Point2DComparator();
    protected static Logger m_Logger = LoggingHelper.getLogger(LOWESS.class);
    public static final int MIN_WINDOW_SIZE = 1;

    public static List<Point2D> calculate(List<Point2D> points, int windowSize) {
        ArrayList<Point2D> result = new ArrayList<Point2D>();
        points = new ArrayList<Point2D>(points);
        Collections.sort(points, m_Comparator);
        if (windowSize > points.size()) {
            windowSize = points.size();
            m_Logger.warning("Window size changed to number of points");
        }
        for (int i = 0; i < points.size(); ++i) {
            int j;
            ArrayList<Point2D> closest = new ArrayList<Point2D>();
            closest.add(points.get(i));
            double ref = points.get(i).getX();
            int left = i - 1;
            int right = i + 1;
            for (int index = 1; index < windowSize; ++index) {
                if (left < 0) {
                    closest.add(points.get(right));
                    ++right;
                    continue;
                }
                if (right > points.size() - 1) {
                    closest.add(points.get(left));
                    --left;
                    continue;
                }
                if (Math.abs(points.get(right).getX() - ref) < Math.abs(points.get(left).getX() - ref)) {
                    closest.add(points.get(right));
                    ++right;
                    continue;
                }
                closest.add(points.get(left));
                --left;
            }
            double max = Math.abs(((Point2D)closest.get(windowSize - 1)).getX() - ref);
            double[] relDist = new double[closest.size()];
            for (j = 0; j < closest.size(); ++j) {
                relDist[j] = Math.abs(((Point2D)closest.get(j)).getX() - ref) / max;
            }
            double[] weighting = new double[relDist.length];
            for (j = 0; j < relDist.length; ++j) {
                weighting[j] = Math.pow(1.0 - Math.pow(relDist[j], 3.0), 3.0);
            }
            double sumWts = 0.0;
            double sumWtX = 0.0;
            double sumWtX2 = 0.0;
            double sumWtY = 0.0;
            double sumWtXY = 0.0;
            for (j = 0; j < weighting.length; ++j) {
                sumWts += weighting[j];
                sumWtX += weighting[j] * ((Point2D)closest.get(j)).getX();
                sumWtX2 += weighting[j] * Math.pow(((Point2D)closest.get(j)).getX(), 2.0);
                sumWtY += weighting[j] * ((Point2D)closest.get(j)).getY();
                sumWtXY += weighting[j] * ((Point2D)closest.get(j)).getY() * ((Point2D)closest.get(j)).getX();
            }
            double denom = sumWts * sumWtX2 - Math.pow(sumWtX, 2.0);
            double slope = (sumWts * sumWtXY - sumWtX * sumWtY) / denom;
            double intercept = (sumWtX2 * sumWtY - sumWtX * sumWtXY) / denom;
            double val = slope * ((Point2D)closest.get(0)).getX() + intercept;
            result.add(new Point2D.Double(((Point2D)closest.get(0)).getX(), val));
        }
        return result;
    }
}

