/*
 * Decompiled with CFR 0.152.
 */
package adams.db;

import adams.core.CloneHandler;
import adams.core.Properties;
import adams.core.Utils;
import adams.core.base.BasePassword;
import adams.core.logging.LoggingHelper;
import adams.core.logging.LoggingLevel;
import adams.core.logging.LoggingObject;
import adams.core.option.OptionHandler;
import adams.core.option.OptionManager;
import adams.core.option.OptionUtils;
import adams.db.ConnectionParameters;
import adams.db.DatabaseConnectionParameterHandler;
import adams.db.DatabaseManager;
import adams.db.Drivers;
import adams.env.Environment;
import adams.event.DatabaseConnectionChangeEvent;
import adams.event.DatabaseConnectionChangeListener;
import com.mysql.jdbc.CommunicationsException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;

public abstract class AbstractDatabaseConnection
extends LoggingObject
implements OptionHandler,
DatabaseConnectionParameterHandler,
Comparable<AbstractDatabaseConnection>,
CloneHandler<AbstractDatabaseConnection> {
    private static final long serialVersionUID = -3625820307854172417L;
    public static final int NO_ERROR = 0;
    public static final int MALFORMED_CONNECTION = 1;
    public static final int CONNECTION_FAIL = 2;
    public static final String PREFIX_CONNECTION = "connection";
    public static final String SUFFIX_COUNT = "count";
    protected static HashSet<AbstractDatabaseConnection> m_ConnectionObjects = new HashSet();
    protected OptionManager m_OptionManager;
    protected transient HashSet<DatabaseConnectionChangeListener> m_ChangeListeners;
    protected Properties m_Properties;
    protected Hashtable<String, Integer> m_FailedConnectAttempts;
    protected String m_URL;
    protected String m_User;
    protected BasePassword m_Password;
    protected boolean m_ConnectOnStartUp;
    protected int m_MaxConnectAttempts;
    protected int m_ReconnectWait;
    protected boolean m_AutoCommit;
    protected transient Connection m_Connection;
    protected boolean m_ConnectionOK;
    protected String m_LastConnectionError;
    protected DatabaseManager m_Owner;

    protected AbstractDatabaseConnection() {
        this.initialize();
        this.defineOptions();
        this.getOptionManager().setDefaults();
        this.finishInit();
    }

    protected AbstractDatabaseConnection(String url, String user, BasePassword password) {
        this();
        this.setURL(url);
        this.setUser(user);
        this.setPassword(password);
        this.setLoggingLevel(this.getDefaultLoggingLevel());
        if (this.getConnectOnStartUp()) {
            try {
                this.connect();
            }
            catch (Exception e) {
                this.m_LastConnectionError = e.toString();
                this.getLogger().log(Level.SEVERE, "Failed to connect", e);
            }
            if (this.m_ConnectionOK) {
                this.m_LastConnectionError = "";
            }
        }
    }

    protected void initialize() {
        Drivers.getSingleton();
        this.m_Connection = null;
        this.m_FailedConnectAttempts = new Hashtable();
        this.m_ConnectionOK = false;
        this.m_LastConnectionError = "";
        this.m_Owner = null;
        this.m_AutoCommit = false;
    }

    protected void finishInit() {
        AbstractDatabaseConnection.getConnectionObjects().add(this);
    }

    public void setOwner(DatabaseManager value) {
        this.m_Owner = value;
    }

    public DatabaseManager getOwner() {
        return this.m_Owner;
    }

    protected HashSet<DatabaseConnectionChangeListener> getChangeListeners() {
        if (this.m_ChangeListeners == null) {
            this.m_ChangeListeners = new HashSet();
        }
        return this.m_ChangeListeners;
    }

    protected OptionManager newOptionManager() {
        return new OptionManager(this);
    }

    @Override
    public void defineOptions() {
        this.m_OptionManager = this.newOptionManager();
        this.m_OptionManager.add("logging-level", "loggingLevel", (Object)this.getDefaultLoggingLevel());
        this.m_OptionManager.add("url", "URL", this.getDefaultURL(), false);
        this.m_OptionManager.add("user", "user", this.getDefaultUser(), false);
        this.m_OptionManager.add("password", "password", this.getDefaultPassword(), false);
        this.m_OptionManager.add("max-attempts", "maxConnectAttempts", this.getDefaultMaxConnectAttempts());
        this.m_OptionManager.add("reconnect-wait", "reconnectWait", this.getDefaultReconnectWait());
        this.m_OptionManager.add("connect-on-startup", "connectOnStartUp", this.getDefaultConnectOnStartUp());
        this.m_OptionManager.add("auto-commit", "autoCommit", this.getDefaultAutoCommit());
    }

    @Override
    public OptionManager getOptionManager() {
        if (this.m_OptionManager == null) {
            this.defineOptions();
        }
        return this.m_OptionManager;
    }

    @Override
    public void cleanUpOptions() {
        if (this.m_OptionManager != null) {
            this.m_OptionManager.cleanUp();
            this.m_OptionManager = null;
        }
    }

    @Override
    public void destroy() {
        this.cleanUpOptions();
    }

    protected abstract String getDefinitionKey();

    protected synchronized Properties readProperties() {
        return Environment.getInstance().read(this.getDefinitionKey());
    }

    public synchronized Properties getProperties() {
        if (this.m_Properties == null) {
            this.m_Properties = this.readProperties();
        }
        return this.m_Properties;
    }

    public LoggingLevel getDefaultLoggingLevel() {
        return LoggingLevel.valueOf(this.getProperties().getProperty("LoggingLevel", LoggingLevel.WARNING.toString()));
    }

    public void setDefaultLoggingLevel(LoggingLevel value) {
        this.getProperties().setProperty("LoggingLevel", value.toString());
    }

    public void setLoggingLevel(LoggingLevel value) {
        this.m_LoggingLevel = value;
        this.getLogger().setLevel(value.getLevel());
    }

    public String loggingLevelTipText() {
        return "The logging level; use FINE or more to have the most detailed output.";
    }

    @Override
    protected void configureLogger() {
        super.configureLogger();
        if (this.getLoggingLevel() != null) {
            this.getLogger().setLevel(this.getLoggingLevel().getLevel());
        }
    }

    public String getDefaultURL() {
        return this.getProperties().getProperty("URL", "");
    }

    public void setDefaultURL(String value) {
        this.getProperties().setProperty("URL", value);
    }

    @Override
    public String getURL() {
        return this.m_URL;
    }

    @Override
    public void setURL(String value) {
        if (this.isConnected()) {
            return;
        }
        if (value == null) {
            return;
        }
        if (value.equals("")) {
            return;
        }
        this.m_URL = value;
        this.m_ConnectionOK = false;
    }

    @Override
    public String URLTipText() {
        return "The JDBC database URL to connect to.";
    }

    public String getDefaultUser() {
        return this.getProperties().getProperty("User", "");
    }

    public void setDefaultUser(String value) {
        this.getProperties().setProperty("User", value);
    }

    @Override
    public String getUser() {
        return this.m_User;
    }

    @Override
    public void setUser(String value) {
        if (this.isConnected()) {
            return;
        }
        this.m_User = value;
        this.m_ConnectionOK = false;
    }

    @Override
    public String userTipText() {
        return "The name of the database user.";
    }

    public BasePassword getDefaultPassword() {
        return new BasePassword(this.getProperties().getProperty("Password", ""));
    }

    public void setDefaultPassword(BasePassword value) {
        this.getProperties().setProperty("Password", value.stringValue());
    }

    @Override
    public BasePassword getPassword() {
        return this.m_Password;
    }

    @Override
    public void setPassword(BasePassword value) {
        if (this.isConnected()) {
            return;
        }
        this.m_Password = value;
        this.m_ConnectionOK = false;
    }

    @Override
    public String passwordTipText() {
        return "The password of the database user.";
    }

    public int getMaxConnectAttempts() {
        return this.m_MaxConnectAttempts;
    }

    public void setMaxConnectAttempts(int value) {
        if (this.isConnected()) {
            return;
        }
        this.m_MaxConnectAttempts = value;
        this.m_ConnectionOK = false;
    }

    public int getDefaultMaxConnectAttempts() {
        return this.getProperties().getInteger("MaxConnectAttempts", 1);
    }

    public String maxConnectAttemptsTipText() {
        return "The maximum number of connection attempts for a driver/URL/user/pw combination.";
    }

    public int getReconnectWait() {
        return this.m_ReconnectWait;
    }

    public void setReconnectWait(int value) {
        if (this.isConnected()) {
            return;
        }
        this.m_ReconnectWait = value;
        this.m_ConnectionOK = false;
    }

    public int getDefaultReconnectWait() {
        return this.getProperties().getInteger("ReconnectWait", 10);
    }

    public String reconnectWaitTipText() {
        return "The number of seconds to wait before trying to reconnect.";
    }

    public boolean getDefaultConnectOnStartUp() {
        return this.getProperties().getBoolean("ConnectOnStartup", false);
    }

    public void setDefaultConnectOnStartUp(boolean value) {
        this.getProperties().setBoolean("ConnectOnStartup", value);
    }

    public boolean getConnectOnStartUp() {
        return this.m_ConnectOnStartUp;
    }

    public void setConnectOnStartUp(boolean value) {
        if (this.isConnected()) {
            return;
        }
        this.m_ConnectOnStartUp = value;
        this.m_ConnectionOK = false;
    }

    public String connectOnStartUpTipText() {
        return "Whether to connect on startup.";
    }

    public boolean getDefaultAutoCommit() {
        return this.getProperties().getBoolean("AutoCommit", true);
    }

    public void setDefaultAutoCommit(boolean value) {
        this.getProperties().setBoolean("AutoCommit", value);
    }

    public boolean getAutoCommit() {
        return this.m_AutoCommit;
    }

    public void setAutoCommit(boolean value) {
        if (this.isConnected()) {
            return;
        }
        this.m_AutoCommit = value;
        this.m_ConnectionOK = false;
    }

    public String autoCommitTipText() {
        return "Whether to set the auto-commit property for the connection.";
    }

    public ConnectionParameters getCurrentConnection() {
        ConnectionParameters result = this.newConnectionParameters();
        result.setParameter("URL", this.getURL());
        result.setParameter("User", this.getUser());
        result.setParameter("Password", this.getPassword().stringValue());
        result.setParameter("LoggingLevel", "" + (Object)((Object)this.getLoggingLevel()));
        result.setParameter("ConnectOnStartup", "" + this.getConnectOnStartUp());
        result.setParameter("AutoCommit", "" + this.getAutoCommit());
        return result;
    }

    protected String getFailedConnectAttemptKey(String url, String user, BasePassword password) {
        String result = url + "\t" + user + "\t" + password;
        return result;
    }

    protected int getFailedConnectAttempt(String url, String user, BasePassword password) {
        String key = this.getFailedConnectAttemptKey(url, user, password);
        int result = !this.m_FailedConnectAttempts.containsKey(key) ? 0 : this.m_FailedConnectAttempts.get(key);
        return result;
    }

    protected void incFailedConnectAttempt(String url, String user, BasePassword password) {
        String key = this.getFailedConnectAttemptKey(url, user, password);
        int count = this.getFailedConnectAttempt(url, user, password);
        this.m_FailedConnectAttempts.put(key, ++count);
        this.m_LastConnectionError = "Failed connection attempt: URL=" + url + ", user=" + user + ", pw=" + password;
    }

    protected void resetFailedConnectAttempt(String url, String user, BasePassword password) {
        String key = this.getFailedConnectAttemptKey(url, user, password);
        this.m_FailedConnectAttempts.put(key, 0);
        this.m_LastConnectionError = "";
    }

    public String getLastConnectionError() {
        return this.m_LastConnectionError;
    }

    public synchronized Connection getConnection(boolean keepTrying) {
        if (!this.m_ConnectionOK) {
            if (keepTrying) {
                if (!this.tryConnection()) {
                    return null;
                }
            } else {
                return null;
            }
        }
        return this.m_Connection;
    }

    protected boolean tryConnection() {
        if (LoggingHelper.isAtLeast(this.getLogger(), Level.FINE)) {
            this.getLogger().log(Level.FINE, "tryConnection request originated from:\n" + Utils.getStackTrace(-1));
        }
        while (!this.m_ConnectionOK) {
            if (this.m_LastConnectionError.indexOf("CommunicationsException") > -1) {
                return false;
            }
            if (this.getFailedConnectAttempt(this.m_URL, this.m_User, this.m_Password) >= this.m_MaxConnectAttempts) {
                this.m_LastConnectionError = "Too many failed connection attempts: URL=" + this.m_URL + ", user=" + this.m_User + ", pw=" + this.m_Password;
                return false;
            }
            try {
                this.connect();
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, "Failed to connect", e);
            }
            if (this.m_ConnectionOK) continue;
            try {
                for (int i = 0; i < this.m_ReconnectWait * 10; ++i) {
                    this.wait(100L);
                    if (this.getFailedConnectAttempt(this.m_URL, this.m_User, this.m_Password) < this.m_MaxConnectAttempts) continue;
                    this.m_LastConnectionError = "Too many failed connection attempts: URL=" + this.m_URL + ", user=" + this.m_User + ", pw=" + this.m_Password;
                    return false;
                }
            }
            catch (InterruptedException e) {
                this.getLogger().log(Level.SEVERE, "Interrupted", e);
            }
        }
        return true;
    }

    public boolean isConnectionOK() {
        return this.m_ConnectionOK;
    }

    public synchronized boolean isConnected() {
        boolean result;
        boolean bl = result = this.m_Connection != null;
        if (result) {
            try {
                result = !this.m_Connection.isClosed();
            }
            catch (Exception e) {
                result = false;
            }
            if (!result) {
                this.m_Connection = null;
            }
        }
        return result;
    }

    public synchronized boolean retryConnect() {
        this.disconnect();
        try {
            return this.connect();
        }
        catch (Exception e) {
            return false;
        }
    }

    public synchronized boolean connect() throws Exception {
        this.m_LastConnectionError = "";
        this.getLogger().info("connecting: " + this.m_URL);
        if (LoggingHelper.isAtLeast(this.getLogger(), Level.FINE)) {
            this.getLogger().log(Level.FINE, "Connection request originated from:\n" + Utils.getStackTrace(-1));
        }
        if (!this.isConnected()) {
            if (this.getFailedConnectAttempt(this.m_URL, this.m_User, this.m_Password) >= this.getMaxConnectAttempts()) {
                this.m_ConnectionOK = false;
                this.m_LastConnectionError = "Maximum number of connection attempts reached: URL=" + this.m_URL + ", user=" + this.m_User + ", pw=" + this.m_Password;
                this.getLogger().severe(this.m_LastConnectionError);
                return false;
            }
            if (this.m_User.equals("")) {
                this.m_Connection = DriverManager.getConnection(this.m_URL);
            } else {
                try {
                    this.m_Connection = DriverManager.getConnection(this.m_URL, this.m_User, this.m_Password.getValue());
                }
                catch (CommunicationsException e) {
                    this.m_Connection = null;
                    this.m_LastConnectionError = e.toString();
                }
                catch (Exception e) {
                    this.m_Connection = null;
                    this.m_LastConnectionError = e.toString();
                }
                if (this.m_Connection == null) {
                    this.getLogger().severe("Cannot connect: " + this.m_LastConnectionError + "\n" + "- URL: " + this.m_URL + "\n" + "- user: " + this.m_User + "\n" + "- pw: " + this.m_Password.stringValue() + "\n");
                    this.incFailedConnectAttempt(this.m_URL, this.m_User, this.m_Password);
                    return false;
                }
            }
        }
        try {
            if (this.m_AutoCommit) {
                this.m_Connection.setAutoCommit(true);
            } else {
                this.m_Connection.setAutoCommit(false);
            }
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to set autocommit", e);
        }
        this.m_ConnectionOK = this.isConnected();
        if (!this.m_ConnectionOK) {
            this.incFailedConnectAttempt(this.m_URL, this.m_User, this.m_Password);
        } else {
            this.resetFailedConnectAttempt(this.m_URL, this.m_User, this.m_Password);
        }
        this.notifyChangeListeners(new DatabaseConnectionChangeEvent(this, DatabaseConnectionChangeEvent.EventType.CONNECT));
        return this.m_ConnectionOK;
    }

    public synchronized boolean disconnect() {
        if (LoggingHelper.isAtLeast(this.getLogger(), Level.FINE)) {
            this.getLogger().log(Level.FINE, "Disconnect request originated from:", Utils.getStackTrace(-1));
        }
        if (this.m_Connection != null) {
            this.getLogger().info("disconnecting: " + this.m_URL);
            try {
                this.m_Connection.close();
            }
            catch (Exception e) {
                this.getLogger().severe("Failed to close connection");
                this.m_Connection = null;
                return false;
            }
            this.m_Connection = null;
        }
        this.m_ConnectionOK = false;
        this.notifyChangeListeners(new DatabaseConnectionChangeEvent(this, DatabaseConnectionChangeEvent.EventType.DISCONNECT));
        return true;
    }

    public ConnectionParameters newConnectionParameters() {
        return new ConnectionParameters();
    }

    public ConnectionParameters getDefaultConnection() {
        ConnectionParameters result = this.newConnectionParameters();
        result.setParameter("URL", this.getDefaultURL());
        result.setParameter("User", this.getDefaultUser());
        result.setParameter("Password", this.getDefaultPassword().stringValue());
        result.setParameter("LoggingLevel", "" + (Object)((Object)this.getDefaultLoggingLevel()));
        result.setParameter("ConnectOnStartup", "" + this.getDefaultConnectOnStartUp());
        result.setParameter("AutoCommit", "" + this.getDefaultAutoCommit());
        return result;
    }

    public List<ConnectionParameters> getConnections() {
        ArrayList<ConnectionParameters> result = new ArrayList<ConnectionParameters>();
        result.add(this.getDefaultConnection());
        Properties props = this.getProperties();
        if (props.hasKey("connection.count")) {
            int count = props.getInteger("connection.count", 0);
            for (int i = 0; i < count; ++i) {
                String prefix = "connection." + i + ".";
                ConnectionParameters conn = ConnectionParameters.forName(props.getProperty(prefix + "Class"));
                Enumeration<String> keys = props.propertyNames("connection\\." + i + "\\." + ".*");
                while (keys.hasMoreElements()) {
                    String key = keys.nextElement();
                    conn.setParameter(key.substring(prefix.length()), props.getProperty(key));
                }
                if (result.contains(conn)) continue;
                result.add(conn);
            }
        }
        return result;
    }

    public boolean addConnection(ConnectionParameters conn) {
        List<ConnectionParameters> connections = this.getConnections();
        if (connections.contains(conn)) {
            connections.remove(conn);
        }
        connections.add(0, conn);
        Properties props = this.getProperties();
        props.removeWithPrefix(PREFIX_CONNECTION);
        props.setInteger("connection.count", connections.size());
        for (int i = 0; i < connections.size(); ++i) {
            props.setProperty("connection." + i + "." + "Class", conn.getClass().getName());
            Enumeration<String> params = connections.get(i).parameters();
            while (params.hasMoreElements()) {
                String param = params.nextElement();
                String obj = connections.get(i).getParameter(param);
                if (obj instanceof String) {
                    props.setProperty("connection." + i + "." + param, obj);
                    continue;
                }
                if (obj instanceof Integer) {
                    props.setInteger("connection." + i + "." + param, (Integer)((Object)obj));
                    continue;
                }
                if (obj instanceof Double) {
                    props.setDouble("connection." + i + "." + param, (Double)((Object)obj));
                    continue;
                }
                if (obj instanceof Boolean) {
                    props.setBoolean("connection." + i + "." + param, (Boolean)((Object)obj));
                    continue;
                }
                props.setProperty("connection." + i + "." + param, "" + obj);
            }
        }
        boolean result = this.updateConnections();
        if (!result) {
            System.err.println("Error adding connection: " + conn);
        }
        return result;
    }

    public synchronized boolean makeDefaultConnection(ConnectionParameters conn) {
        this.setDefaultURL(conn.getURL());
        this.setDefaultUser(conn.getUser());
        this.setDefaultPassword(conn.getPassword());
        this.setDefaultLoggingLevel(conn.getLoggingLevel());
        this.setDefaultConnectOnStartUp(conn.getConnectOnStartUp());
        this.setDefaultAutoCommit(conn.getAutoCommit());
        boolean result = this.updateConnections();
        if (!result) {
            System.err.println("Error setting default connection: " + conn);
        } else if (this.getOwner() != null) {
            this.getOwner().setDefault(this.getDefaultConnection().toDatabaseConnection(this.getClass()));
        }
        return result;
    }

    public boolean updateConnections() {
        return Environment.getInstance().write(this.getDefinitionKey(), this.getProperties());
    }

    protected void outputChangeListeners() {
        this.getLogger().fine("DB change listeners: #" + this.getChangeListeners().size());
        for (DatabaseConnectionChangeListener list : this.getChangeListeners()) {
            this.getLogger().fine("  " + list.getClass().getName());
        }
    }

    public void addChangeListener(DatabaseConnectionChangeListener l) {
        this.getChangeListeners().add(l);
        if (this.isLoggingEnabled()) {
            this.outputChangeListeners();
        }
    }

    public void removeChangeListener(DatabaseConnectionChangeListener l) {
        this.getChangeListeners().remove(l);
        if (this.isLoggingEnabled()) {
            this.outputChangeListeners();
        }
    }

    public synchronized void notifyChangeListeners(DatabaseConnectionChangeEvent e) {
        int count = 0;
        DatabaseConnectionChangeListener[] listeners = this.getChangeListeners().toArray(new DatabaseConnectionChangeListener[this.getChangeListeners().size()]);
        if (this.isLoggingEnabled()) {
            this.getLogger().fine("Notifying about: " + (Object)((Object)e.getType()));
        }
        for (DatabaseConnectionChangeListener listener : listeners) {
            ++count;
            long start = System.currentTimeMillis();
            listener.databaseConnectionStateChanged(e);
            if (!this.isLoggingEnabled()) continue;
            this.getLogger().fine(count + "/" + this.getChangeListeners().size() + ": " + listener.getClass().getName() + " (" + (System.currentTimeMillis() - start) + "ms)");
        }
    }

    @Override
    public int compareTo(AbstractDatabaseConnection o) {
        if (o == null) {
            return 1;
        }
        int result = Utils.compare((Comparable)((Object)this.getURL()), (Comparable)((Object)o.getURL()));
        if (result == 0) {
            result = Utils.compare((Comparable)((Object)this.getUser()), (Comparable)((Object)o.getUser()));
        }
        return result;
    }

    public boolean equals(Object o) {
        if (o instanceof AbstractDatabaseConnection) {
            return this.compareTo((AbstractDatabaseConnection)o) == 0;
        }
        return false;
    }

    public int hashCode() {
        return new String(this.getURL() + "\t" + this.getUser()).hashCode();
    }

    @Override
    public synchronized AbstractDatabaseConnection getClone() {
        AbstractDatabaseConnection result = (AbstractDatabaseConnection)OptionUtils.shallowCopy(this, false);
        if (this.isConnected()) {
            result.m_Connection = this.m_Connection;
            result.m_ConnectionOK = this.m_ConnectionOK;
            result.m_LastConnectionError = this.m_LastConnectionError;
        }
        result.getChangeListeners().addAll(this.getChangeListeners());
        if (this.getOwner() != null) {
            this.getOwner().add(result);
        }
        return result;
    }

    public String toStringShort() {
        String result = this.getURL().replaceAll(".*:\\/\\/", "").replaceAll("\\..*\\/", "/");
        return result;
    }

    public String toString() {
        String result = "url=" + this.getURL();
        result = result + ", user=" + this.getUser();
        result = result + ", password=" + this.getPassword();
        result = result + ", connected=" + this.isConnected();
        result = result + ", #listeners=" + this.getChangeListeners().size();
        return result;
    }

    public static HashSet<AbstractDatabaseConnection> getConnectionObjects() {
        return m_ConnectionObjects;
    }

    public static HashSet<AbstractDatabaseConnection> getActiveConnectionObjects() {
        AbstractDatabaseConnection[] conns;
        HashSet<AbstractDatabaseConnection> result = new HashSet<AbstractDatabaseConnection>();
        for (AbstractDatabaseConnection dbcon : conns = m_ConnectionObjects.toArray(new AbstractDatabaseConnection[m_ConnectionObjects.size()])) {
            if (!dbcon.isConnected()) continue;
            result.add(dbcon);
        }
        return result;
    }
}

