/*
 * Decompiled with CFR 0.152.
 */
package adams.doc.javadoc;

import adams.core.ClassLocator;
import adams.core.TechnicalInformationHandler;
import adams.doc.javadoc.Javadoc;

public class TechnicalInformationHandlerJavadoc
extends Javadoc {
    private static final long serialVersionUID = 270395165932401302L;
    public static final String PLAINTEXT_STARTTAG = "<!-- technical-plaintext-start -->";
    public static final String PLAINTEXT_ENDTAG = "<!-- technical-plaintext-end -->";
    public static final String BIBTEX_STARTTAG = "<!-- technical-bibtex-start -->";
    public static final String BIBTEX_ENDTAG = "<!-- technical-bibtex-end -->";
    protected boolean m_Prolog;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_StartTag = new String[2];
        this.m_EndTag = new String[2];
        this.m_IsBlock = new boolean[2];
        this.m_StartTag[0] = PLAINTEXT_STARTTAG;
        this.m_EndTag[0] = PLAINTEXT_ENDTAG;
        this.m_IsBlock[0] = true;
        this.m_StartTag[1] = BIBTEX_STARTTAG;
        this.m_EndTag[1] = BIBTEX_ENDTAG;
        this.m_IsBlock[1] = true;
        this.m_Prolog = true;
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("noprolog", "Prolog", false);
    }

    public void setProlog(boolean value) {
        this.m_Prolog = value;
    }

    public boolean getProlog() {
        return this.m_Prolog;
    }

    public String PrologTipText() {
        return "Controls the 'BibTex:' prolog in the Javadoc.";
    }

    @Override
    protected String generateJavadoc(int index) throws Exception {
        String result = "";
        if (!this.canInstantiateClass()) {
            return result;
        }
        if (!ClassLocator.hasInterface(TechnicalInformationHandler.class, this.getInstance().getClass())) {
            throw new Exception("Class '" + this.getClassname() + "' is not a TechnicalInformationHandler!");
        }
        TechnicalInformationHandler handler = (TechnicalInformationHandler)this.getInstance();
        switch (index) {
            case 0: {
                result = this.toHTML(handler.getTechnicalInformation().toString()) + "\n";
                break;
            }
            case 1: {
                if (this.getProlog()) {
                    result = "BibTeX:\n";
                }
                result = result + "<pre>\n";
                result = result + this.toHTML(handler.getTechnicalInformation().toBibTex()).replaceAll("<br/>", "") + "\n";
                result = result + "</pre>\n<p/>\n";
            }
        }
        if (this.getUseStars()) {
            result = this.indent(result, 1, "* ");
        }
        return result;
    }

    public static void main(String[] args) {
        TechnicalInformationHandlerJavadoc.runJavadoc(TechnicalInformationHandlerJavadoc.class, args);
    }
}

