/*
 * Decompiled with CFR 0.152.
 */
package adams.flow;

import adams.core.Pausable;
import adams.core.Stoppable;
import adams.core.Utils;
import adams.core.VariablesHandler;
import adams.core.base.BaseRegExp;
import adams.core.io.DirectoryLister;
import adams.core.io.PlaceholderDirectory;
import adams.core.io.PlaceholderFile;
import adams.core.logging.LoggingHelper;
import adams.core.management.ProcessUtils;
import adams.core.option.AbstractOptionConsumer;
import adams.core.option.AbstractOptionHandler;
import adams.core.option.ArrayConsumer;
import adams.core.option.OptionUtils;
import adams.env.Environment;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.core.ActorUtils;
import adams.gui.application.AbstractInitialization;
import adams.gui.scripting.ScriptingEngine;
import java.awt.GraphicsEnvironment;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.logging.Level;

public class FlowRunner
extends AbstractOptionHandler
implements Stoppable,
Pausable {
    private static final long serialVersionUID = 5693250462014974198L;
    public static final String METHOD_STOPALLENGINES = "stopAllEngines";
    protected PlaceholderFile m_Input;
    protected BaseRegExp m_Include;
    protected boolean m_Headless;
    protected String m_Home;
    protected boolean m_NoExecute;
    protected boolean m_CleanUp;
    protected AbstractActor m_Actor;
    protected AbstractActor m_LastActor;
    protected boolean m_InterruptedByUser;

    @Override
    public String globalInfo() {
        return "Executes flows from command-line.\nIt is also possible to traverse a directory and execute all flows within that match a regular expression.\nUsing the 'no-execute' option, you can suppress the flow execution, but still test whether the flow loads and can be fully set up and wrapped up.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("home", "home", "");
        this.m_OptionManager.add("headless", "headless", false);
        this.m_OptionManager.add("input", "input", new PlaceholderFile("."));
        this.m_OptionManager.add("include", "include", new BaseRegExp(".*\\.(flow|flow.gz)"));
        this.m_OptionManager.add("clean-up", "cleanUp", false);
        this.m_OptionManager.add("no-execute", "noExecute", false);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Actor = null;
        this.m_LastActor = null;
    }

    public void setHome(String value) {
        this.m_Home = value;
        this.reset();
    }

    public String getHome() {
        return this.m_Home;
    }

    public String homeTipText() {
        return "The directory to use as the project's home directory, overriding the automatically determined one.";
    }

    public void setHeadless(boolean value) {
        this.m_Headless = value;
        this.reset();
    }

    public boolean isHeadless() {
        return this.m_Headless;
    }

    public String headlessTipText() {
        return "If set to true, the actor is run in headless mode without GUI components.";
    }

    public void setInput(PlaceholderFile value) {
        this.m_Input = value;
        this.reset();
    }

    public PlaceholderFile getInput() {
        return this.m_Input;
    }

    public String inputTipText() {
        return "The file (or directory containing flows) to load the actor from.";
    }

    public void setInclude(BaseRegExp value) {
        this.m_Include = value;
        this.reset();
    }

    public BaseRegExp getInclude() {
        return this.m_Include;
    }

    public String includeTipText() {
        return "The regular expression for including flows when traversing a directory rather than just executing a single flow.";
    }

    public void setCleanUp(boolean value) {
        this.m_CleanUp = value;
        this.reset();
    }

    public boolean isCleanUp() {
        return this.m_CleanUp;
    }

    public String cleanUpTipText() {
        return "If set to true, then a clean up is performed after execution, removing any graphical output as well.";
    }

    public void setNoExecute(boolean value) {
        this.m_NoExecute = value;
        this.reset();
    }

    public boolean isNoExecute() {
        return this.m_NoExecute;
    }

    public String noExecuteTipText() {
        return "If set to true, then flow execution is suppressed; flow is only loaded, set up and wrapped up.";
    }

    public AbstractActor getLastActor() {
        return this.m_LastActor;
    }

    public String execute() {
        String result = null;
        this.m_InterruptedByUser = false;
        if (this.isLoggingEnabled()) {
            this.getLogger().info("PID: " + ProcessUtils.getVirtualMachinePID());
        }
        AbstractInitialization.initAll();
        if (this.m_LastActor != null) {
            this.m_LastActor.destroy();
        }
        if (!this.m_Input.isDirectory()) {
            ArrayList<String> errors = new ArrayList<String>();
            this.m_Actor = ActorUtils.read(this.m_Input.getAbsolutePath(), errors);
            if (!errors.isEmpty()) {
                result = "Failed to load actor from '" + this.m_Input + "'!\n" + Utils.flatten(errors, "\n");
                return result;
            }
            if (this.m_Actor instanceof VariablesHandler) {
                ActorUtils.updateVariablesWithFlowFilename((VariablesHandler)((Object)this.m_Actor), this.m_Input);
            }
            if (!(this.m_Actor instanceof Flow)) {
                this.getLogger().warning("Root element is not a " + Flow.class.getName() + ": " + this.m_Input + ", skipping");
                return null;
            }
        } else {
            DirectoryLister lister = new DirectoryLister();
            lister.setListFiles(true);
            lister.setListDirs(false);
            lister.setSorting(DirectoryLister.Sorting.SORT_BY_NAME);
            lister.setWatchDir(new PlaceholderDirectory(this.m_Input));
            lister.setRegExp(this.m_Include);
            String[] flows = lister.list();
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Found #" + flows.length + " flows");
            }
            if (LoggingHelper.isAtLeast(this.getLogger(), Level.FINE)) {
                this.getLogger().fine("Flows: " + Utils.arrayToString(flows));
            }
            for (String flow : flows) {
                if (this.isLoggingEnabled()) {
                    this.getLogger().info("Running: " + flow);
                }
                this.setInput(new PlaceholderFile(flow));
                result = this.execute();
                if (result != null) break;
            }
            return result;
        }
        this.m_LastActor = this.m_Actor;
        if (this.isLoggingEnabled()) {
            this.getLogger().fine("Actor command-line: " + this.m_Actor.toCommandLine());
        }
        try {
            this.m_Actor.setHeadless(this.isHeadless() || GraphicsEnvironment.isHeadless());
            if (this.isLoggingEnabled() && this.m_Actor.isHeadless()) {
                this.getLogger().info("Running in headless mode");
            }
            result = this.m_Actor.setUp();
            if (this.isLoggingEnabled()) {
                this.getLogger().info("setUp() result: " + result);
            }
            if (!this.m_NoExecute) {
                if (result == null) {
                    result = this.m_Actor.execute();
                    if (this.isLoggingEnabled()) {
                        this.getLogger().info("execute() result: " + result);
                    }
                    if (this.m_Actor.hasStopMessage()) {
                        this.getLogger().info("stop message: " + this.m_Actor.getStopMessage());
                        if (result == null) {
                            result = this.m_Actor.getStopMessage();
                        }
                    }
                }
            } else {
                this.getLogger().info("execute suppressed");
            }
            this.m_Actor.wrapUp();
            if (this.isLoggingEnabled()) {
                this.getLogger().info("wrapUp() finished");
            }
            if (this.m_CleanUp) {
                this.m_Actor.cleanUp();
                if (this.isLoggingEnabled()) {
                    this.getLogger().info("cleanUp() finished");
                }
            }
            if (result != null) {
                result = !this.m_Input.isDirectory() ? "Error executing flow '" + this.m_Input + "': " + result : "Error executing actor: " + result;
            }
        }
        catch (Exception e) {
            result = e.toString();
            e.printStackTrace();
        }
        this.m_Actor = null;
        if (this.m_InterruptedByUser && result == null) {
            result = "Flow interrupted by user!";
        }
        return result;
    }

    @Override
    public void pauseExecution() {
        if (this.m_Actor != null && this.m_Actor instanceof Pausable) {
            ((Pausable)((Object)this.m_Actor)).pauseExecution();
        }
    }

    @Override
    public boolean isPaused() {
        if (this.m_Actor != null && this.m_Actor instanceof Pausable) {
            return ((Pausable)((Object)this.m_Actor)).isPaused();
        }
        return false;
    }

    @Override
    public void resumeExecution() {
        if (this.m_Actor != null && this.m_Actor instanceof Pausable) {
            ((Pausable)((Object)this.m_Actor)).resumeExecution();
        }
    }

    @Override
    public void stopExecution() {
        if (this.m_Actor != null) {
            this.m_InterruptedByUser = true;
            this.m_Actor.stopExecution();
        }
    }

    public static FlowRunner forName(String classname, String[] options) {
        FlowRunner result;
        try {
            result = (FlowRunner)OptionUtils.forName(FlowRunner.class, classname, options);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    public static FlowRunner forCommandLine(String cmdline) {
        return (FlowRunner)AbstractOptionConsumer.fromString(ArrayConsumer.class, cmdline);
    }

    protected static void stopAllEngines(Class[] engines) {
        for (int i = 0; i < engines.length; ++i) {
            try {
                Method method = engines[i].getMethod(METHOD_STOPALLENGINES, new Class[0]);
                method.invoke(null, new Object[0]);
                continue;
            }
            catch (Exception e) {
                System.err.println("Failed to call " + engines[i].getName() + "." + METHOD_STOPALLENGINES + ":");
                e.printStackTrace();
            }
        }
    }

    public static void runFlow(Class env, Class flow, Class[] engines, String[] args) {
        Environment.setEnvironmentClass(env);
        Environment.setHome(OptionUtils.getOption(args, "-home"));
        LoggingHelper.useHandlerFromOptions(args);
        try {
            if (OptionUtils.helpRequested(args)) {
                System.out.println("Help requested...\n");
                FlowRunner flowInst = FlowRunner.forName(flow.getName(), new String[0]);
                System.out.print("\n" + OptionUtils.list(flowInst));
                LoggingHelper.outputHandlerOption();
            } else {
                FlowRunner flowInst = FlowRunner.forName(flow.getName(), args);
                ArrayConsumer.setOptions(flowInst, args);
                String result = flowInst.execute();
                FlowRunner.stopAllEngines(engines);
                if (result == null) {
                    System.out.println("\nFinished execution!");
                } else {
                    System.err.println("\n" + result);
                    System.exit(1);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        FlowRunner.runFlow(Environment.class, FlowRunner.class, new Class[]{ScriptingEngine.class}, args);
    }
}

