/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.condition.bool;

import adams.core.io.PlaceholderFile;
import adams.core.scripting.FileBasedScriptingWithOptions;
import adams.flow.condition.bool.AbstractBooleanCondition;
import adams.flow.core.Actor;
import adams.flow.core.Token;
import adams.flow.core.Unknown;

public abstract class AbstractScriptedCondition
extends AbstractBooleanCondition
implements FileBasedScriptingWithOptions {
    private static final long serialVersionUID = -1266048092842841686L;
    protected PlaceholderFile m_ScriptFile;
    protected String m_ScriptOptions;
    protected transient Object m_ScriptObject;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("script", "scriptFile", new PlaceholderFile("."));
        this.m_OptionManager.add("options", "scriptOptions", "");
    }

    @Override
    public void reset() {
        super.reset();
        this.m_ScriptObject = null;
    }

    @Override
    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("scriptFile");
        if (variable != null) {
            return variable;
        }
        return new String(this.m_ScriptFile + " " + this.m_ScriptOptions).trim();
    }

    @Override
    public void setScriptFile(PlaceholderFile value) {
        this.m_ScriptFile = value;
        this.reset();
    }

    @Override
    public PlaceholderFile getScriptFile() {
        return this.m_ScriptFile;
    }

    @Override
    public String scriptFileTipText() {
        return "The script file to load and execute.";
    }

    @Override
    public void setScriptOptions(String value) {
        this.m_ScriptOptions = value;
        this.reset();
    }

    @Override
    public String getScriptOptions() {
        return this.m_ScriptOptions;
    }

    @Override
    public String scriptOptionsTipText() {
        return "The options for the script.";
    }

    protected abstract String loadScriptObject();

    protected abstract String checkScriptObject();

    protected String initScriptObject() {
        String result = this.loadScriptObject();
        if (result == null) {
            result = this.checkScriptObject();
        }
        return result;
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Unknown.class};
    }

    @Override
    public String setUp(Actor owner) {
        String result = super.setUp(owner);
        if (result == null) {
            result = this.initScriptObject();
        }
        return result;
    }

    protected abstract boolean doScriptEvaluate(Actor var1, Token var2);

    @Override
    protected boolean doEvaluate(Actor owner, Token token) {
        String msg;
        if (this.m_ScriptObject == null && (msg = this.initScriptObject()) != null) {
            throw new IllegalStateException(msg);
        }
        return this.doScriptEvaluate(owner, token);
    }
}

