/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control;

import adams.core.CleanUpHandler;
import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.Variables;
import adams.core.base.BaseString;
import adams.core.option.DebugNestedProducer;
import adams.core.option.OptionHandler;
import adams.flow.condition.bool.BooleanCondition;
import adams.flow.condition.bool.BooleanConditionSupporter;
import adams.flow.condition.bool.Expression;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.core.ActorUtils;
import adams.flow.core.ControlActor;
import adams.flow.core.Token;
import adams.flow.core.Unknown;
import adams.flow.transformer.AbstractTransformer;
import adams.gui.core.BaseFrame;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseTabbedPane;
import adams.gui.core.GUIHelper;
import adams.gui.core.MenuBarProvider;
import adams.gui.core.TextEditorPanel;
import adams.gui.flow.StoragePanel;
import adams.gui.goe.GenericObjectEditorPanel;
import adams.gui.tools.ExpressionWatchPanel;
import adams.gui.tools.VariableManagementPanel;
import adams.gui.visualization.debug.InspectionPanel;
import adams.parser.BooleanExpression;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Breakpoint
extends AbstractTransformer
implements ControlActor,
BooleanConditionSupporter {
    private static final long serialVersionUID = 1670185555433805533L;
    protected BooleanCondition m_Condition;
    protected BaseString[] m_Watches;
    protected ExpressionWatchPanel.ExpressionType[] m_WatchTypes;
    protected int m_X;
    protected int m_Y;
    protected int m_Width;
    protected int m_Height;
    protected BasePanel m_Panel;
    protected BaseFrame m_Frame;
    protected boolean m_Disabled;
    protected transient Token m_CurrentToken;
    protected View[] m_Views;
    protected Boolean m_Updating;

    @Override
    public String globalInfo() {
        return "Allows to pause the execution of the flow when this actor is reached and the condition evaluates to 'true'.\nIt is possible to define watches as well.\n\nThe expression has the following underlying grammar:\n" + new BooleanExpression().getGrammar();
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("x", "x", this.getDefaultX(), -3, null);
        this.m_OptionManager.add("y", "y", this.getDefaultY(), -3, null);
        this.m_OptionManager.add("width", "width", this.getDefaultWidth(), 1, null);
        this.m_OptionManager.add("height", "height", this.getDefaultHeight(), 1, null);
        this.m_OptionManager.add("condition", "condition", new Expression());
        this.m_OptionManager.add("watch", "watches", new BaseString[0]);
        this.m_OptionManager.add("watch-type", "watchTypes", new ExpressionWatchPanel.ExpressionType[0]);
        this.m_OptionManager.add("view", "views", new View[0]);
    }

    @Override
    public String getQuickInfo() {
        String variable;
        String result = QuickInfoHelper.toString((OptionHandler)this, "condition", this.m_Condition.getQuickInfo());
        if (this.m_Watches.length > 0 || QuickInfoHelper.hasVariable(this, "watches")) {
            variable = QuickInfoHelper.getVariable(this, "watches");
            if (result.length() > 0) {
                result = result + ", ";
            }
            if (variable != null) {
                result = result + variable;
            } else {
                result = result + this.m_Watches.length + " watch";
                if (this.m_Watches.length > 1) {
                    result = result + "es";
                }
            }
        }
        if (this.m_Views.length > 0 || QuickInfoHelper.hasVariable(this, "views")) {
            if (result.length() > 0) {
                result = result + ", ";
            }
            result = result + "view";
            variable = QuickInfoHelper.getVariable(this, "views");
            if (variable != null) {
                result = result + variable;
            } else {
                if (this.m_Views.length > 1) {
                    result = result + "s";
                }
                result = result + ": ";
                for (int i = 0; i < this.m_Views.length; ++i) {
                    if (i > 0) {
                        result = result + ", ";
                    }
                    result = result + (Object)((Object)this.m_Views[i]);
                }
            }
        }
        return result;
    }

    protected int getDefaultX() {
        return -3;
    }

    public void setX(int value) {
        this.m_X = value;
        this.reset();
    }

    public int getX() {
        return this.m_X;
    }

    public String xTipText() {
        return "The X position of the dialog (>=0: absolute, -1: left, -2: center, -3: right).";
    }

    protected int getDefaultY() {
        return -1;
    }

    public void setY(int value) {
        this.m_Y = value;
        this.reset();
    }

    public int getY() {
        return this.m_Y;
    }

    public String yTipText() {
        return "The Y position of the dialog (>=0: absolute, -1: top, -2: center, -3: bottom).";
    }

    protected int getDefaultWidth() {
        return 800;
    }

    public void setWidth(int value) {
        this.m_Width = value;
        this.reset();
    }

    public int getWidth() {
        return this.m_Width;
    }

    public String widthTipText() {
        return "The width of the dialog.";
    }

    protected int getDefaultHeight() {
        return 800;
    }

    public void setHeight(int value) {
        this.m_Height = value;
        this.reset();
    }

    public int getHeight() {
        return this.m_Height;
    }

    public String heightTipText() {
        return "The height of the dialog.";
    }

    @Override
    public void setCondition(BooleanCondition value) {
        this.m_Condition = value;
        this.reset();
    }

    @Override
    public BooleanCondition getCondition() {
        return this.m_Condition;
    }

    public String conditionTipText() {
        return "The condition to evaluate; if the condition evaluates to 'true', the execution of the flow is paused and a control window is opened.";
    }

    public void setWatches(BaseString[] value) {
        for (int i = 0; i < value.length; ++i) {
            if (!Variables.isPlaceholder(value[i].getValue())) continue;
            value[i] = new BaseString("(" + value[i].getValue() + ")");
        }
        this.m_Watches = value;
        this.reset();
    }

    public BaseString[] getWatches() {
        return this.m_Watches;
    }

    public String watchesTipText() {
        return "The expression to display initially in the watch dialog; the type of the watch needs to be specified as well.";
    }

    public void setWatchTypes(ExpressionWatchPanel.ExpressionType[] value) {
        this.m_WatchTypes = value;
        this.reset();
    }

    public ExpressionWatchPanel.ExpressionType[] getWatchTypes() {
        return this.m_WatchTypes;
    }

    public String watchTypesTipText() {
        return "The types of the watch expressions; determines how the expressions get evaluated and displayed.";
    }

    public void setViews(View[] value) {
        this.m_Views = value;
        this.reset();
    }

    public View[] getViews() {
        return this.m_Views;
    }

    public String viewsTipText() {
        return "The views to display automatically when the breakpoint is reached.";
    }

    protected BasePanel newPanel() {
        ControlPanel result = new ControlPanel();
        for (int i = 0; i < this.m_Watches.length; ++i) {
            result.addWatch(this.m_Watches[i].getValue(), this.m_WatchTypes[i]);
        }
        return result;
    }

    protected boolean evalCondition(Token input) {
        return this.m_Condition.evaluate(this, input);
    }

    @Override
    public String setUp() {
        String result = super.setUp();
        if (result == null && this.m_Watches.length != this.m_WatchTypes.length) {
            Utils.adjustArray(this.m_WatchTypes, this.m_Watches.length, (Object)ExpressionWatchPanel.ExpressionType.STRING);
        }
        return result;
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Unknown.class};
    }

    protected void setDisabled(boolean value) {
        this.m_Disabled = value;
    }

    protected boolean isDisabled() {
        return this.m_Disabled;
    }

    protected BaseFrame createFrame(BasePanel panel) {
        BaseFrame result = new BaseFrame(this.getName());
        result.getContentPane().setLayout(new BorderLayout());
        result.getContentPane().add((Component)panel, "Center");
        result.setDefaultCloseOperation(1);
        ImageIcon icon = GUIHelper.getIcon(this.getClass());
        if (icon != null) {
            result.setIconImage(icon.getImage());
        } else {
            result.setIconImage(GUIHelper.getIcon("flow.gif").getImage());
        }
        if (panel instanceof MenuBarProvider) {
            result.setJMenuBar(((MenuBarProvider)((Object)panel)).getMenuBar());
        } else if (this instanceof MenuBarProvider) {
            result.setJMenuBar(((MenuBarProvider)((Object)this)).getMenuBar());
        }
        result.setSize(this.m_Width, this.m_Height);
        result.setLocation(ActorUtils.determineLocation(result, this.m_X, this.m_Y));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String doExecute() {
        String result = null;
        this.m_CurrentToken = this.m_InputToken;
        if (!this.isHeadless() && !this.isDisabled()) {
            if (this.evalCondition(this.m_CurrentToken)) {
                ((Flow)this.getRoot()).pauseExecution();
                if (this.m_Panel == null) {
                    this.m_Panel = this.newPanel();
                    this.m_Frame = this.createFrame(this.m_Panel);
                }
                Runnable run = new Runnable(){

                    @Override
                    public void run() {
                        if (!Breakpoint.this.m_Frame.isVisible()) {
                            Breakpoint.this.m_Frame.setVisible(true);
                        }
                        ((ControlPanel)Breakpoint.this.m_Panel).breakpointReached();
                    }
                };
                SwingUtilities.invokeLater(run);
                while (((Flow)this.getRoot()).isPaused()) {
                    AbstractActor abstractActor = this.m_Self;
                    synchronized (abstractActor) {
                        try {
                            this.m_Self.wait(100L);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                }
            } else {
                this.m_OutputToken = this.m_CurrentToken;
            }
        } else {
            this.m_OutputToken = this.m_CurrentToken;
        }
        return result;
    }

    @Override
    public Class[] generates() {
        return new Class[]{Unknown.class};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopExecution() {
        if (this.m_Frame != null && this.m_Frame.isVisible()) {
            this.m_Frame.setVisible(false);
        }
        try {
            AbstractActor abstractActor = this.m_Self;
            synchronized (abstractActor) {
                this.m_Self.notifyAll();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.stopExecution();
    }

    @Override
    public void wrapUp() {
        this.m_CurrentToken = null;
        this.doCleanUpGUI();
        super.wrapUp();
    }

    protected void cleanUpGUI() {
        if (this.m_Frame != null) {
            if (this.m_Panel instanceof CleanUpHandler) {
                ((CleanUpHandler)((Object)this.m_Panel)).cleanUp();
            }
            this.m_Frame.setVisible(false);
            this.m_Frame.dispose();
            this.m_Frame = null;
            this.m_Panel = null;
        }
    }

    protected void doCleanUpGUI() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Breakpoint.this.cleanUpGUI();
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    @Override
    public void cleanUp() {
        this.doCleanUpGUI();
        super.cleanUp();
    }

    public static enum View {
        SOURCE,
        EXPRESSIONS,
        VARIABLES,
        STORAGE,
        INSPECT_TOKEN,
        INSPECT_FLOW;

    }

    public class ControlPanel
    extends BasePanel
    implements CleanUpHandler {
        private static final long serialVersionUID = 1000900663466801934L;
        protected BaseTabbedPane m_TabbedPane;
        protected JToggleButton m_ButtonContinue;
        protected JToggleButton m_ButtonStop;
        protected JToggleButton m_ButtonDisableEnable;
        protected JToggleButton m_ButtonExpressions;
        protected GenericObjectEditorPanel m_PanelCondition;
        protected JToggleButton m_ButtonConditionUpdate;
        protected JToggleButton m_ButtonSource;
        protected JToggleButton m_ButtonVariables;
        protected JToggleButton m_ButtonStorage;
        protected JToggleButton m_ButtonInspectToken;
        protected JToggleButton m_ButtonInspectFlow;
        protected ExpressionWatchPanel m_PanelExpressions;
        protected VariableManagementPanel m_PanelVariables;
        protected InspectionPanel m_PanelInspectionToken;
        protected InspectionPanel m_PanelInspectionFlow;
        protected TextEditorPanel m_PanelSource;
        protected StoragePanel m_PanelStorage;
        protected JTextField m_TextActorPath;
        protected JToggleButton m_ButtonActorPath;

        @Override
        protected void initGUI() {
            super.initGUI();
            this.setLayout(new BorderLayout());
            this.m_TabbedPane = new BaseTabbedPane();
            this.add((Component)this.m_TabbedPane, "Center");
            JPanel panelAllButtons = new JPanel(new BorderLayout());
            this.add((Component)panelAllButtons, "North");
            JPanel panel = new JPanel(new BorderLayout());
            panel.setBorder(BorderFactory.createTitledBorder("Execution"));
            panelAllButtons.add((Component)panel, "North");
            JPanel panelButtons = new JPanel(new GridLayout(1, 3));
            panel.add((Component)panelButtons, "North");
            this.m_ButtonContinue = new JToggleButton("Continue", GUIHelper.getIcon("run.gif"));
            this.m_ButtonContinue.setMnemonic('C');
            this.m_ButtonContinue.setToolTipText("Continues with the flow execution");
            this.m_ButtonContinue.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ControlPanel.this.continueFlowExecution();
                }
            });
            panelButtons.add(this.m_ButtonContinue);
            this.m_ButtonStop = new JToggleButton("Stop", GUIHelper.getIcon("stop.gif"));
            this.m_ButtonStop.setMnemonic('S');
            this.m_ButtonStop.setToolTipText("Stops the flow execution immediately");
            this.m_ButtonStop.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ControlPanel.this.stopFlowExecution();
                }
            });
            panelButtons.add(this.m_ButtonStop);
            this.m_ButtonDisableEnable = new JToggleButton("Disable", GUIHelper.getIcon("debug_off.png"));
            this.m_ButtonDisableEnable.setMnemonic('D');
            this.m_ButtonDisableEnable.setToolTipText("Disable the breakpoint");
            this.m_ButtonDisableEnable.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ControlPanel.this.disableEnableBreakpoint();
                }
            });
            panelButtons.add(this.m_ButtonDisableEnable);
            JPanel panelCondition = new JPanel(new FlowLayout(0));
            panel.add((Component)panelCondition, "Center");
            this.m_PanelCondition = new GenericObjectEditorPanel(BooleanCondition.class, new Breakpoint().getCondition(), true);
            this.m_PanelCondition.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    ControlPanel.this.update();
                }
            });
            this.m_ButtonConditionUpdate = new JToggleButton("Update");
            this.m_ButtonConditionUpdate.setToolTipText("Update the breakpoint condition");
            this.m_ButtonConditionUpdate.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ControlPanel.this.updateCondition();
                }
            });
            panelCondition.add(new JLabel("Condition"));
            panelCondition.add(this.m_PanelCondition);
            panelCondition.add(this.m_ButtonConditionUpdate);
            panelButtons = new JPanel(new GridLayout(2, 3));
            panelButtons.setBorder(BorderFactory.createTitledBorder("Runtime information"));
            panel = new JPanel(new BorderLayout());
            panel.add((Component)panelButtons, "North");
            panelAllButtons.add((Component)panel, "Center");
            this.m_ButtonExpressions = new JToggleButton("Expressions", GUIHelper.getIcon("glasses.gif"));
            this.m_ButtonExpressions.setMnemonic('x');
            this.m_ButtonExpressions.setToolTipText("Display dialog for watch expressions");
            this.m_ButtonExpressions.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ControlPanel.this.showWatchExpressions(ControlPanel.this.m_ButtonExpressions.isSelected());
                }
            });
            panelButtons.add(this.m_ButtonExpressions);
            this.m_ButtonVariables = new JToggleButton("Variables", GUIHelper.getIcon("variable.gif"));
            this.m_ButtonVariables.setMnemonic('V');
            this.m_ButtonVariables.setToolTipText("Display dialog with currently active variables");
            this.m_ButtonVariables.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ControlPanel.this.showVariables(ControlPanel.this.m_ButtonVariables.isSelected());
                }
            });
            panelButtons.add(this.m_ButtonVariables);
            this.m_ButtonStorage = new JToggleButton("Storage", GUIHelper.getIcon("disk.png"));
            this.m_ButtonStorage.setMnemonic('t');
            this.m_ButtonStorage.setToolTipText("Display dialog with items currently stored in temporary storage");
            this.m_ButtonStorage.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ControlPanel.this.showStorage(ControlPanel.this.m_ButtonStorage.isSelected());
                }
            });
            panelButtons.add(this.m_ButtonStorage);
            this.m_ButtonInspectToken = new JToggleButton("Inspect token", GUIHelper.getIcon("properties.gif"));
            this.m_ButtonInspectToken.setMnemonic('I');
            this.m_ButtonInspectToken.setToolTipText("Display dialog for inspecting the current token");
            this.m_ButtonInspectToken.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ControlPanel.this.inspectToken(ControlPanel.this.m_ButtonInspectToken.isSelected());
                }
            });
            panelButtons.add(this.m_ButtonInspectToken);
            this.m_ButtonInspectFlow = new JToggleButton("Inspect flow", GUIHelper.getIcon("flow.gif"));
            this.m_ButtonInspectFlow.setMnemonic('n');
            this.m_ButtonInspectFlow.setToolTipText("Display dialog for inspecting the current flow");
            this.m_ButtonInspectFlow.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ControlPanel.this.inspectFlow(ControlPanel.this.m_ButtonInspectFlow.isSelected());
                }
            });
            panelButtons.add(this.m_ButtonInspectFlow);
            this.m_ButtonSource = new JToggleButton("Source", GUIHelper.getIcon("source.png"));
            this.m_ButtonSource.setMnemonic('o');
            this.m_ButtonSource.setToolTipText("Display current flow state as source (nested format)");
            this.m_ButtonSource.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ControlPanel.this.showSource(ControlPanel.this.m_ButtonSource.isSelected());
                }
            });
            panelButtons.add(this.m_ButtonSource);
            panel = new JPanel(new FlowLayout(0));
            this.m_TextActorPath = new JTextField(30);
            this.m_TextActorPath.setEditable(false);
            this.m_ButtonActorPath = new JToggleButton(GUIHelper.getIcon("copy.gif"));
            this.m_ButtonActorPath.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GUIHelper.copyToClipboard(ControlPanel.this.m_TextActorPath.getText());
                }
            });
            panel.add(new JLabel("Actor path"));
            panel.add(this.m_TextActorPath);
            panel.add(this.m_ButtonActorPath);
            panelAllButtons.add((Component)panel, "South");
            this.m_PanelExpressions = new ExpressionWatchPanel();
        }

        protected Flow getFlow() {
            return (Flow)Breakpoint.this.getRoot();
        }

        protected void update() {
            Flow flow = this.getFlow();
            this.m_ButtonContinue.setEnabled(flow.isPaused());
            this.m_ButtonStop.setEnabled(!flow.isStopped());
            this.m_ButtonDisableEnable.setEnabled(!flow.isStopped());
            this.m_ButtonExpressions.setEnabled(flow.isPaused());
            this.m_ButtonInspectFlow.setEnabled(flow.isPaused());
            this.m_ButtonInspectToken.setEnabled(flow.isPaused());
            this.m_ButtonSource.setEnabled(flow.isPaused());
            this.m_ButtonConditionUpdate.setEnabled(flow.isPaused());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void continueFlowExecution() {
            BooleanCondition current = (BooleanCondition)this.m_PanelCondition.getCurrent();
            if (!current.equals(Breakpoint.this.getCondition())) {
                Breakpoint.this.m_Condition = current.shallowCopy();
            }
            Breakpoint.this.m_OutputToken = Breakpoint.this.m_CurrentToken;
            AbstractActor abstractActor = Breakpoint.this.m_Self;
            synchronized (abstractActor) {
                try {
                    Breakpoint.this.m_Self.notifyAll();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.getFlow().resumeExecution();
            this.update();
        }

        protected void stopFlowExecution() {
            if (this.getParentDialog() != null) {
                this.getParentDialog().setVisible(false);
            } else if (this.getParentFrame() != null) {
                this.getParentFrame().setVisible(false);
            }
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ControlPanel.this.getFlow().stopExecution("User stopped flow!");
                }
            };
            SwingUtilities.invokeLater(runnable);
        }

        protected void disableEnableBreakpoint() {
            Breakpoint.this.setDisabled(!Breakpoint.this.isDisabled());
            if (Breakpoint.this.isDisabled()) {
                this.m_ButtonDisableEnable.setText("Enable");
                this.m_ButtonDisableEnable.setMnemonic('E');
                this.m_ButtonDisableEnable.setToolTipText("Enable the breakpoint");
                this.m_ButtonDisableEnable.setIcon(GUIHelper.getIcon("debug.png"));
            } else {
                this.m_ButtonDisableEnable.setText("Disable");
                this.m_ButtonDisableEnable.setMnemonic('D');
                this.m_ButtonDisableEnable.setToolTipText("Disable the breakpoint");
                this.m_ButtonDisableEnable.setIcon(GUIHelper.getIcon("debug_off.png"));
            }
            Flow flow = this.getFlow();
            if (flow.isPaused()) {
                Breakpoint.this.m_OutputToken = Breakpoint.this.m_CurrentToken;
                flow.resumeExecution();
            }
            this.update();
        }

        protected void setPanelVisible(JPanel panel, String title, boolean visible) {
            int present = -1;
            for (int i = 0; i < this.m_TabbedPane.getTabCount(); ++i) {
                if (this.m_TabbedPane.getComponentAt(i) != panel) continue;
                present = i;
                break;
            }
            if (visible && present > -1 || !visible && present == -1) {
                return;
            }
            if (visible) {
                this.m_TabbedPane.addTab(title, panel);
                this.m_TabbedPane.setSelectedIndex(this.m_TabbedPane.getTabCount() - 1);
            } else {
                this.m_TabbedPane.remove(present);
            }
        }

        protected void showWatchExpressions(boolean visible) {
            this.m_PanelExpressions.setVariables(Breakpoint.this.getVariables());
            this.setPanelVisible(this.m_PanelExpressions, "Expressions", visible);
        }

        protected void showSource(boolean visible) {
            String content;
            if (this.m_PanelSource == null) {
                this.m_PanelSource = new TextEditorPanel();
                this.m_PanelSource.setTextFont(GUIHelper.getMonospacedFont());
                this.m_PanelSource.setEditable(false);
                this.m_PanelSource.setTabSize(2);
            }
            if (visible) {
                DebugNestedProducer producer = new DebugNestedProducer();
                producer.produce(this.getFlow());
                content = producer.toString();
                producer.cleanUp();
            } else {
                content = "";
            }
            this.m_PanelSource.setContent(content);
            this.setPanelVisible(this.m_PanelSource, "Source", visible);
        }

        protected void showVariables(boolean visible) {
            if (this.m_PanelVariables == null) {
                this.m_PanelVariables = new VariableManagementPanel();
            }
            this.m_PanelVariables.setVariables(Breakpoint.this.getVariables());
            this.setPanelVisible(this.m_PanelVariables, "Variables", visible);
        }

        protected void inspectToken(boolean visible) {
            if (this.m_PanelInspectionToken == null) {
                this.m_PanelInspectionToken = new InspectionPanel();
            }
            this.m_PanelInspectionToken.setCurrent(Breakpoint.this.m_CurrentToken);
            this.setPanelVisible(this.m_PanelInspectionToken, "Token", visible);
        }

        protected void inspectFlow(boolean visible) {
            if (this.m_PanelInspectionFlow == null) {
                this.m_PanelInspectionFlow = new InspectionPanel();
            }
            this.m_PanelInspectionFlow.setCurrent(Breakpoint.this.m_Self.getRoot());
            this.setPanelVisible(this.m_PanelInspectionFlow, "Flow", visible);
        }

        protected void showStorage(boolean visible) {
            if (this.m_PanelStorage == null) {
                this.m_PanelStorage = new StoragePanel();
            }
            this.setPanelVisible(this.m_PanelStorage, "Storage", visible);
            this.m_PanelStorage.setHandler(Breakpoint.this.getStorageHandler());
        }

        public void breakpointReached() {
            this.m_TextActorPath.setText(Breakpoint.this.getFullName());
            this.m_PanelExpressions.refreshAllExpressions();
            this.m_PanelCondition.setCurrent(Breakpoint.this.getCondition().shallowCopy());
            if (this.m_PanelInspectionToken != null) {
                this.m_PanelInspectionToken.setCurrent(Breakpoint.this.m_CurrentToken);
            }
            if (this.m_PanelInspectionFlow != null) {
                this.m_PanelInspectionFlow.setCurrent(Breakpoint.this.m_Self.getRoot());
            }
            if (this.m_PanelStorage != null) {
                this.m_PanelStorage.setHandler(Breakpoint.this.getStorageHandler());
            }
            this.update();
            block8: for (View d : Breakpoint.this.m_Views) {
                switch (d) {
                    case SOURCE: {
                        this.m_ButtonSource.setSelected(true);
                        this.showSource(true);
                        continue block8;
                    }
                    case EXPRESSIONS: {
                        this.m_ButtonExpressions.setSelected(true);
                        this.showWatchExpressions(true);
                        continue block8;
                    }
                    case INSPECT_TOKEN: {
                        this.m_ButtonInspectToken.setSelected(true);
                        this.inspectToken(true);
                        continue block8;
                    }
                    case INSPECT_FLOW: {
                        this.m_ButtonInspectFlow.setSelected(true);
                        this.inspectFlow(true);
                        continue block8;
                    }
                    case STORAGE: {
                        this.m_ButtonStorage.setSelected(true);
                        this.showStorage(true);
                        continue block8;
                    }
                    case VARIABLES: {
                        this.m_ButtonVariables.setSelected(true);
                        this.showVariables(true);
                        continue block8;
                    }
                    default: {
                        throw new IllegalStateException("Unhandled dialog type: " + (Object)((Object)d));
                    }
                }
            }
        }

        public void updateCondition() {
            Breakpoint.this.setCondition(((BooleanCondition)this.m_PanelCondition.getCurrent()).shallowCopy());
        }

        public void addWatch(String expr, ExpressionWatchPanel.ExpressionType type) {
            this.m_PanelExpressions.addExpression(expr, type);
        }

        @Override
        public void cleanUp() {
            if (this.m_PanelSource != null) {
                this.m_PanelSource = null;
            }
            if (this.m_PanelExpressions != null) {
                this.m_PanelExpressions = null;
            }
            if (this.m_PanelVariables != null) {
                this.m_PanelVariables = null;
            }
            if (this.m_PanelInspectionToken != null) {
                this.m_PanelInspectionToken = null;
            }
            if (this.m_PanelInspectionFlow != null) {
                this.m_PanelInspectionFlow = null;
            }
            if (this.m_PanelStorage != null) {
                this.m_PanelStorage.cleanUp();
                this.m_PanelStorage = null;
            }
        }
    }
}

