/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.condition.bool.BooleanCondition;
import adams.flow.condition.bool.Counting;
import adams.flow.control.Tee;
import adams.flow.core.Token;
import java.util.Hashtable;

public class Count
extends Tee {
    private static final long serialVersionUID = -3408173173526076280L;
    public static final String BACKUP_CURRENT = "current";
    protected BooleanCondition m_Condition;
    protected boolean m_IncrementOnlyIfConditionMet;
    protected int m_Current;

    @Override
    public String globalInfo() {
        return "Counts the number of tokens that pass through and meet the condition and tees off the current count every n-th token.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("condition", "condition", new Counting());
        this.m_OptionManager.add("increment-only-if-condition-met", "incrementOnlyIfConditionMet", false);
    }

    @Override
    public String getQuickInfo() {
        String result = this.m_Condition.getQuickInfo();
        result = result + QuickInfoHelper.toString((OptionHandler)this, "incrementOnlyIfConditionMet", this.m_IncrementOnlyIfConditionMet, "[incr. only if condition met]", " ");
        if (super.getQuickInfo() != null) {
            result = result + ", " + super.getQuickInfo();
        }
        return result;
    }

    public void setCondition(BooleanCondition value) {
        this.m_Condition = value;
        this.reset();
    }

    public BooleanCondition getCondition() {
        return this.m_Condition;
    }

    public String conditionTipText() {
        return "The boolean condition to evaluate.";
    }

    public void setIncrementOnlyIfConditionMet(boolean value) {
        this.m_IncrementOnlyIfConditionMet = value;
        this.reset();
    }

    public boolean getIncrementOnlyIfConditionMet() {
        return this.m_IncrementOnlyIfConditionMet;
    }

    public String incrementOnlyIfConditionMetTipText() {
        return "If enabled, the counter gets only incremented if the condition is met; useful if you want to count tokens of a certain value.";
    }

    @Override
    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_CURRENT);
    }

    @Override
    protected Hashtable<String, Object> backupState() {
        Hashtable<String, Object> result = super.backupState();
        result.put(BACKUP_CURRENT, this.m_Current);
        return result;
    }

    @Override
    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_CURRENT)) {
            this.m_Current = (Integer)state.get(BACKUP_CURRENT);
            state.remove(BACKUP_CURRENT);
        }
        super.restoreState(state);
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_Current = 0;
    }

    @Override
    public void input(Token token) {
        if (!this.m_IncrementOnlyIfConditionMet) {
            ++this.m_Current;
        }
        super.input(token);
    }

    protected boolean canFire() {
        return this.m_Condition.evaluate(this, this.m_InputToken);
    }

    @Override
    protected boolean canProcessInput(Token token) {
        return super.canProcessInput(token) && this.canFire();
    }

    @Override
    protected Token createTeeToken(Token token) {
        return new Token(new Integer(this.m_Current));
    }

    @Override
    protected String processInput(Token token) {
        if (this.m_IncrementOnlyIfConditionMet) {
            ++this.m_Current;
        }
        return super.processInput(token);
    }

    @Override
    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            result = this.m_Condition.setUp(this);
        }
        return result;
    }
}

