/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.Variables;
import adams.core.base.BaseText;
import adams.core.logging.LoggingLevel;
import adams.core.management.ProcessUtils;
import adams.core.option.OptionHandler;
import adams.flow.control.AbstractControlActor;
import adams.flow.control.Sequence;
import adams.flow.control.Storage;
import adams.flow.control.StorageHandler;
import adams.flow.core.AbstractActor;
import adams.flow.core.ActorExecution;
import adams.flow.core.ActorHandler;
import adams.flow.core.ActorHandlerInfo;
import adams.flow.core.ActorUtils;
import adams.flow.core.InputConsumer;
import adams.flow.core.MutableActorHandler;
import adams.flow.core.Token;
import adams.flow.core.Unknown;
import adams.flow.sink.Null;
import adams.multiprocess.PausableFixedThreadPoolExecutor;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

public class LoadBalancer
extends AbstractControlActor
implements InputConsumer,
MutableActorHandler {
    private static final long serialVersionUID = -8782869993629454572L;
    public static final String BACKUP_CURRENT = "current";
    protected Sequence m_Actors;
    protected transient Token m_CurrentToken;
    protected int m_NumThreads;
    protected int m_ActualNumThreads;
    protected PausableFixedThreadPoolExecutor m_Executor;
    protected boolean m_HasGlobalTransformers;
    protected List<AbstractActor> m_ToCleanUp;
    protected int m_ThreadsSpawned;
    protected boolean m_UseLocalVariables;
    protected boolean m_UseLocalStorage;
    protected boolean m_DeepCopy;

    @Override
    public String globalInfo() {
        return "Runs the specified 'load actor' in as many separate threads as specified with the 'num-threads' parameter.\nNB: (changing) variables cannot be used in the load-balancer actor, as this would create unwanted side-effects.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("load", "loadActors", new AbstractActor[]{new Null()});
        this.m_OptionManager.add("num-threads", "numThreads", -1, -1, null);
        this.m_OptionManager.add("use-local-vars", "useLocalVariables", false);
        this.m_OptionManager.add("use-local-storage", "useLocalStorage", false);
        this.m_OptionManager.add("deep-copy", "deepCopy", false);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_CurrentToken = null;
        this.m_ToCleanUp = new ArrayList<AbstractActor>();
        this.m_Actors = new Sequence();
        this.m_Actors.setAllowStandalones(true);
        this.m_Actors.setAllowSource(true);
    }

    @Override
    protected void updateParent() {
        this.m_Actors.setName(this.getName());
        this.m_Actors.setParent(null);
        this.m_Actors.setParent(this.getParent());
    }

    @Override
    public void setLoggingLevel(LoggingLevel value) {
        super.setLoggingLevel(value);
        this.m_Actors.setLoggingLevel(value);
    }

    public void setLoadActors(AbstractActor[] value) {
        this.m_Actors.setActors(value);
        this.reset();
        this.updateParent();
    }

    public AbstractActor[] getLoadActors() {
        return this.m_Actors.getActors();
    }

    public String loadActorsTipText() {
        return "The actors to 'load-balance'.";
    }

    public void setNumThreads(int value) {
        if (value >= -1) {
            this.m_NumThreads = value;
            this.reset();
        }
    }

    public int getNumThreads() {
        return this.m_NumThreads;
    }

    public String numThreadsTipText() {
        return "The number of threads to use for load-balancing (-1 means one for each core/cpu).";
    }

    public void setUseLocalVariables(boolean value) {
        this.m_UseLocalVariables = value;
        this.reset();
    }

    public boolean getUseLocalVariables() {
        return this.m_UseLocalVariables;
    }

    public String useLocalVariablesTipText() {
        return "If enabled, then each thread will restrict the scope of variables to be local; initially, a copy of all variables is taken at the  thread's time of creation.";
    }

    public void setUseLocalStorage(boolean value) {
        this.m_UseLocalStorage = value;
        this.reset();
    }

    public boolean getUseLocalStorage() {
        return this.m_UseLocalStorage;
    }

    public String useLocalStorageTipText() {
        return "If enabled, then each thread will restrict the scope of storage to be local; initially, a shallow copy of the storage is taken at the thread's time of creation.";
    }

    public void setDeepCopy(boolean value) {
        this.m_DeepCopy = value;
        this.reset();
    }

    public boolean getDeepCopy() {
        return this.m_DeepCopy;
    }

    public String deepCopyTipText() {
        return "If enabled, the local storage gets copied using a deep copy.";
    }

    @Override
    public String getQuickInfo() {
        String result;
        if (this.m_NumThreads == 0 || this.m_NumThreads == 1) {
            result = "sequential";
        } else {
            result = "parallel, threads: ";
            result = this.m_NumThreads == -1 ? result + "#cores" : result + this.m_NumThreads;
        }
        result = QuickInfoHelper.toString((OptionHandler)this, "numThreads", result);
        result = result + QuickInfoHelper.toString((OptionHandler)this, "useLocalVariables", this.m_UseLocalVariables, "local vars", ", ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, "useLocalStorage", this.m_UseLocalStorage, "local storage", ", ");
        if (this.m_UseLocalStorage || QuickInfoHelper.hasVariable(this, "useLocalStorage")) {
            result = result + " (" + QuickInfoHelper.toString((OptionHandler)this, "deepCopy", this.m_DeepCopy, "deep copy") + ")";
        }
        return result;
    }

    @Override
    public int size() {
        return this.m_Actors.size();
    }

    @Override
    public AbstractActor get(int index) {
        return this.m_Actors.get(index);
    }

    @Override
    public void set(int index, AbstractActor actor) {
        this.m_Actors.set(index, actor);
        this.reset();
        this.updateParent();
    }

    @Override
    public int indexOf(String actor) {
        return this.m_Actors.indexOf(actor);
    }

    @Override
    public void add(AbstractActor actor) {
        this.add(this.size(), actor);
    }

    @Override
    public void add(int index, AbstractActor actor) {
        this.m_Actors.add(index, actor);
        this.reset();
        this.updateParent();
    }

    @Override
    public AbstractActor remove(int index) {
        AbstractActor result = this.m_Actors.remove(index);
        this.reset();
        return result;
    }

    @Override
    public void removeAll() {
        this.m_Actors.removeAll();
        this.reset();
    }

    @Override
    public ActorHandlerInfo getActorHandlerInfo() {
        return this.m_Actors.getActorHandlerInfo();
    }

    @Override
    protected Hashtable<String, Object> backupState() {
        Hashtable<String, Object> result = super.backupState();
        if (this.m_CurrentToken != null) {
            result.put(BACKUP_CURRENT, this.m_CurrentToken);
        }
        return result;
    }

    @Override
    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_CURRENT)) {
            this.m_CurrentToken = (Token)state.get(BACKUP_CURRENT);
            state.remove(BACKUP_CURRENT);
        }
        super.restoreState(state);
    }

    @Override
    public Class[] accepts() {
        if (this.m_Actors != null) {
            return this.m_Actors.accepts();
        }
        return new Class[]{Unknown.class};
    }

    protected String setUpLoadActors() {
        Hashtable<String, Integer> count;
        Sequence actor = (Sequence)this.m_Actors.shallowCopy(true);
        actor.setAllowStandalones(true);
        actor.setName(this.getName());
        actor.setParent(null);
        actor.setParent(this.getParent());
        String result = actor.setUp();
        if (result != null) {
            result = "Failed to setUp() load-actors: " + result;
        }
        actor.destroy();
        if (result == null && (count = ActorUtils.findGlobalTransformers(this.m_Actors)).size() > 0) {
            result = "Load-actors contain global transformers, no load-balancing possible: " + count.keySet();
        }
        return result;
    }

    @Override
    protected String setUpSubActors() {
        String result = null;
        if (this.m_Actors.active() == 0) {
            result = "No tee-actors provided!";
        }
        if (result == null && !this.getSkip()) {
            this.updateParent();
            result = this.setUpLoadActors();
        }
        return result;
    }

    @Override
    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            this.m_ActualNumThreads = this.m_NumThreads == -1 ? ProcessUtils.getAvailableProcessors() : (this.m_NumThreads > 1 ? this.m_NumThreads : 1);
            this.m_ThreadsSpawned = 0;
            this.m_Executor = new PausableFixedThreadPoolExecutor(this.m_ActualNumThreads);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void input(Token token) {
        this.m_CurrentToken = token;
        while (this.m_Executor.getActiveCount() >= this.m_Executor.getMaximumPoolSize() && !this.m_Stopped) {
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Waiting for free thread...");
            }
            try {
                PausableFixedThreadPoolExecutor pausableFixedThreadPoolExecutor = this.m_Executor;
                synchronized (pausableFixedThreadPoolExecutor) {
                    this.m_Executor.wait(100L);
                }
            }
            catch (Exception exception) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String doExecute() {
        String result = null;
        this.getScopeHandler().setEnforceGlobalNameCheck(false);
        ++this.m_ThreadsSpawned;
        final Token token = this.m_CurrentToken;
        final int count = this.m_ThreadsSpawned;
        Sequence actor = (Sequence)this.m_Actors.shallowCopy(false);
        actor.setAllowStandalones(true);
        final ThreadShell shell = new ThreadShell(actor, this.m_UseLocalVariables ? this.getVariables().getClone() : this.getVariables(), this.m_UseLocalStorage ? (this.m_DeepCopy ? (Storage)Utils.deepCopy(this.getStorageHandler().getStorage()) : this.getStorageHandler().getStorage().getClone()) : this.getStorageHandler().getStorage());
        shell.setName(this.getName());
        shell.setParent(null);
        shell.setParent(this.getParent());
        shell.setLoggingLevel(this.getLoggingLevel());
        shell.setAnnotations(new BaseText("Thread #" + count));
        this.m_ToCleanUp.add(shell);
        Callable<String> job = new Callable<String>(){

            @Override
            public String call() throws Exception {
                String result = null;
                try {
                    if (LoadBalancer.this.isLoggingEnabled()) {
                        LoadBalancer.this.getLogger().info("Starting thread #" + count);
                    }
                    if ((result = shell.setUp()) == null) {
                        shell.input(token);
                        result = shell.execute();
                        if (result != null) {
                            shell.getLogger().severe(result);
                        }
                    } else {
                        shell.getLogger().severe(result);
                    }
                    if (LoadBalancer.this.isLoggingEnabled()) {
                        LoadBalancer.this.getLogger().info("...finished thread #" + count + (result == null ? "" : " with error"));
                    }
                }
                catch (Exception e) {
                    result = LoadBalancer.this.handleException("Failed to execute thread #" + count + ": ", e);
                }
                return result;
            }
        };
        PausableFixedThreadPoolExecutor pausableFixedThreadPoolExecutor = this.m_Executor;
        synchronized (pausableFixedThreadPoolExecutor) {
            this.m_Executor.submit(job);
        }
        return result;
    }

    @Override
    public void wrapUp() {
        if (this.m_Executor != null) {
            this.m_Executor.shutdown();
            while (!this.m_Executor.isTerminated()) {
                try {
                    this.m_Executor.awaitTermination(100L, TimeUnit.MILLISECONDS);
                }
                catch (Exception exception) {}
            }
            this.m_Executor = null;
        }
        this.m_CurrentToken = null;
        super.wrapUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopExecution() {
        if (this.m_Executor != null) {
            try {
                PausableFixedThreadPoolExecutor pausableFixedThreadPoolExecutor = this.m_Executor;
                synchronized (pausableFixedThreadPoolExecutor) {
                    this.m_Executor.notifyAll();
                    this.m_Executor.shutdownNow();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.stopExecution();
    }

    @Override
    public void cleanUp() {
        this.m_CurrentToken = null;
        for (int i = 0; i < this.m_ToCleanUp.size(); ++i) {
            this.m_ToCleanUp.get(i).cleanUp();
        }
        this.m_ToCleanUp.clear();
        super.cleanUp();
    }

    protected static class ThreadShell
    extends AbstractControlActor
    implements InputConsumer,
    StorageHandler {
        private static final long serialVersionUID = -3358113395261199819L;
        protected AbstractActor m_Actor;
        protected Storage m_LocalStorage;
        protected Variables m_LocalVariables;

        public ThreadShell(AbstractActor actor, Variables vars, Storage storage) {
            if (actor == null) {
                throw new IllegalArgumentException("Actor cannot be null!");
            }
            if (vars == null) {
                throw new IllegalArgumentException("Variables cannot be null!");
            }
            if (storage == null) {
                throw new IllegalArgumentException("Storage cannot be null!");
            }
            this.m_Actor = actor;
            this.m_LocalVariables = vars;
            this.m_LocalStorage = storage;
            this.m_Actor.setVariables(vars);
            this.m_Actor.getOptionManager().updateVariablesInstance(vars);
        }

        @Override
        public String globalInfo() {
            return "Shell around a LoadBalancer thread, in order to provide optional local scope for variables and storage.";
        }

        @Override
        public ActorHandlerInfo getActorHandlerInfo() {
            if (this.m_Actor instanceof ActorHandler) {
                return ((ActorHandler)((Object)this.m_Actor)).getActorHandlerInfo();
            }
            return new ActorHandlerInfo(false, ActorExecution.PARALLEL, true);
        }

        @Override
        public int size() {
            return 1;
        }

        public AbstractActor getActor() {
            return this.m_Actor;
        }

        @Override
        public AbstractActor get(int index) {
            if (index == 0) {
                return this.m_Actor;
            }
            throw new IllegalArgumentException("Illegal index: " + index);
        }

        @Override
        public void set(int index, AbstractActor actor) {
            if (index != 0) {
                throw new IllegalArgumentException("Illegal index: " + index);
            }
            this.m_Actor = actor;
            this.reset();
            this.updateParent();
        }

        @Override
        public int indexOf(String actor) {
            if (this.m_Actor.getName().equals(actor)) {
                return 0;
            }
            return -1;
        }

        @Override
        public synchronized Variables getVariables() {
            return this.m_LocalVariables;
        }

        @Override
        public Storage getStorage() {
            return this.m_LocalStorage;
        }

        @Override
        public StorageHandler getStorageHandler() {
            return this;
        }

        @Override
        public Class[] accepts() {
            if (this.m_Actor instanceof InputConsumer) {
                return ((InputConsumer)((Object)this.m_Actor)).accepts();
            }
            return new Class[0];
        }

        @Override
        public void input(Token token) {
            if (this.m_Actor instanceof InputConsumer) {
                if (this.getFlowExecutionListeningSupporter().isFlowExecutionListeningEnabled()) {
                    this.getFlowExecutionListeningSupporter().getFlowExecutionListener().preInput(this.m_Actor, token);
                }
                ((InputConsumer)((Object)this.m_Actor)).input(token);
                if (this.getFlowExecutionListeningSupporter().isFlowExecutionListeningEnabled()) {
                    this.getFlowExecutionListeningSupporter().getFlowExecutionListener().postInput(this.m_Actor);
                }
            }
        }

        @Override
        protected String doExecute() {
            this.m_Actor.getOptionManager().updateVariableValues(true);
            if (this.getFlowExecutionListeningSupporter().isFlowExecutionListeningEnabled()) {
                this.getFlowExecutionListeningSupporter().getFlowExecutionListener().preExecute(this.m_Actor);
            }
            String result = this.m_Actor.execute();
            if (this.getFlowExecutionListeningSupporter().isFlowExecutionListeningEnabled()) {
                this.getFlowExecutionListeningSupporter().getFlowExecutionListener().postExecute(this.m_Actor);
            }
            return result;
        }
    }
}

