/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.core;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.core.AbstractActor;
import adams.flow.core.GlobalActorHelper;
import adams.flow.core.GlobalActorReference;
import adams.flow.core.GlobalActorUser;
import java.util.HashSet;
import java.util.Hashtable;

public abstract class AbstractGlobalActor
extends AbstractActor
implements GlobalActorUser {
    private static final long serialVersionUID = -6652513967046303107L;
    public static final String BACKUP_GLOBALACTOR = "global actor";
    protected GlobalActorReference m_GlobalName;
    protected AbstractActor m_GlobalActor;
    protected GlobalActorHelper m_Helper;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("global", "globalName", new GlobalActorReference("unknown"));
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_GlobalActor = null;
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Helper = new GlobalActorHelper();
    }

    public void setGlobalName(GlobalActorReference value) {
        this.m_GlobalName = value;
        this.reset();
    }

    public GlobalActorReference getGlobalName() {
        return this.m_GlobalName;
    }

    public String globalNameTipText() {
        return "The name of the global actor to use.";
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, "globalName", this.m_GlobalName);
    }

    protected AbstractActor findGlobalActor() {
        return this.m_Helper.findGlobalActorRecursive(this, this.getGlobalName());
    }

    public boolean hasGlobalActor() {
        return this.m_GlobalActor != null;
    }

    @Override
    public AbstractActor getGlobalActor() {
        return this.m_GlobalActor;
    }

    @Override
    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_GLOBALACTOR);
    }

    @Override
    protected Hashtable<String, Object> backupState() {
        Hashtable<String, Object> result = super.backupState();
        if (this.m_GlobalActor != null) {
            result.put(BACKUP_GLOBALACTOR, this.m_GlobalActor);
        }
        return result;
    }

    @Override
    protected void restoreState(Hashtable<String, Object> state) {
        super.restoreState(state);
        if (state.containsKey(BACKUP_GLOBALACTOR)) {
            this.m_GlobalActor = (AbstractActor)state.get(BACKUP_GLOBALACTOR);
            state.remove(BACKUP_GLOBALACTOR);
        }
    }

    protected String setUpGlobalActor() {
        String result = null;
        this.m_GlobalActor = this.findGlobalActor();
        if (this.m_GlobalActor == null) {
            result = "Couldn't find global actor '" + this.getGlobalName() + "'!";
        } else {
            HashSet<String> variables = this.findVariables(this.m_GlobalActor);
            this.m_DetectedVariables.addAll(variables);
            if (this.m_DetectedVariables.size() > 0) {
                this.getVariables().addVariableChangeListener(this);
            }
        }
        return result;
    }

    @Override
    public String setUp() {
        String variable;
        String result = super.setUp();
        if (result == null && (variable = this.getOptionManager().getVariableForProperty("globalName")) == null) {
            result = this.setUpGlobalActor();
        }
        return result;
    }

    protected abstract String executeGlobalActor();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String doExecute() {
        String result = null;
        if (this.m_GlobalActor == null) {
            result = this.setUpGlobalActor();
        }
        if (result == null && !this.m_GlobalActor.getSkip() && !this.m_GlobalActor.isStopped()) {
            AbstractActor abstractActor = this.m_GlobalActor;
            synchronized (abstractActor) {
                if (this.isLoggingEnabled()) {
                    this.getLogger().info("Executing global actor - start: " + this.m_GlobalActor);
                }
                result = this.executeGlobalActor();
                if (this.isLoggingEnabled()) {
                    this.getLogger().info("Executing global actor - end: " + result);
                }
            }
        }
        return result;
    }

    @Override
    public boolean isFinished() {
        if (this.m_GlobalActor == null) {
            return true;
        }
        return this.m_GlobalActor.isFinished();
    }

    @Override
    public void stopExecution() {
        try {
            if (this.m_GlobalActor != null) {
                this.m_GlobalActor.notifyAll();
                this.m_GlobalActor.stopExecution();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.stopExecution();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void wrapUp() {
        if (this.m_GlobalActor != null) {
            AbstractActor abstractActor = this.m_GlobalActor;
            synchronized (abstractActor) {
                this.m_GlobalActor.wrapUp();
            }
        }
        super.wrapUp();
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        if (this.m_GlobalActor != null) {
            this.m_GlobalActor.cleanUp();
            this.m_GlobalActor = null;
        }
    }
}

