/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.core;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.core.AbstractActor;
import adams.flow.core.GlobalActorHelper;
import adams.flow.core.GlobalActorReference;
import adams.flow.core.PropertyHelper;
import adams.gui.goe.PropertyPath;

public abstract class AbstractPropertyUpdater
extends AbstractActor {
    private static final long serialVersionUID = 8068932300654252910L;
    protected GlobalActorReference m_ActorName;
    protected String m_Property;
    protected transient AbstractActor m_GlobalActor;
    protected transient PropertyPath.PropertyContainer m_Container;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("actor-name", "actorName", new GlobalActorReference("unknown"));
        this.m_OptionManager.add("property", "property", "");
    }

    public void setActorName(GlobalActorReference value) {
        this.m_ActorName = value;
        this.reset();
    }

    public GlobalActorReference getActorName() {
        return this.m_ActorName;
    }

    public String actorNameTipText() {
        return "The name of the global actor to update the property for.";
    }

    public void setProperty(String value) {
        this.m_Property = value;
        this.reset();
    }

    public String getProperty() {
        return this.m_Property;
    }

    public String propertyTipText() {
        return "The property to update whenever the variable changes.";
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, "actorName", this.m_ActorName, "name: ");
        String value = QuickInfoHelper.toString((OptionHandler)this, "property", this.m_Property, ", property: ");
        if (value != null) {
            result = result + value;
        }
        return result;
    }

    protected void updateProperty(String s) {
        Object value = PropertyHelper.convertVariableValue(this.m_Container, s);
        if (value != null) {
            PropertyPath.setValue((Object)this.m_GlobalActor, this.m_Property, value);
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Property '" + this.m_Property + "' of '" + this.m_ActorName + "' changed to: " + value);
            }
        }
    }

    @Override
    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            GlobalActorHelper helper = new GlobalActorHelper();
            this.m_GlobalActor = helper.findGlobalActorRecursive(this, this.m_ActorName);
            if (this.m_GlobalActor == null) {
                result = "Cannot find global actor '" + this.m_ActorName + "'!";
            } else {
                this.m_Container = PropertyPath.find((Object)this.m_GlobalActor, this.m_Property);
                if (this.m_Container == null) {
                    result = "Cannot find property '" + this.m_Property + "' in global actor '" + this.m_ActorName + "'!";
                } else {
                    Class<?> cls = this.m_Container.getReadMethod().getReturnType();
                    if (cls.isArray()) {
                        result = "Property '" + this.m_Property + "' is an array!";
                    }
                }
            }
        }
        return result;
    }

    @Override
    public void wrapUp() {
        super.wrapUp();
        this.m_GlobalActor = null;
    }
}

