/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.processor;

import adams.core.ClassLocator;
import adams.core.VariableName;
import adams.core.Variables;
import adams.core.base.BaseObject;
import adams.core.option.AbstractArgumentOption;
import adams.flow.control.Flow;
import adams.flow.control.LocalScope;
import adams.flow.processor.AbstractNameUpdater;
import java.lang.reflect.Array;
import java.lang.reflect.Method;

public class UpdateVariableName
extends AbstractNameUpdater<VariableName> {
    private static final long serialVersionUID = -5355023022079902959L;

    @Override
    public String globalInfo() {
        return "Updates all occurrences of the old variable name with the new one.";
    }

    @Override
    public String oldNameTipText() {
        return "The old variable name to replace with the new one.";
    }

    @Override
    public String newNameTipText() {
        return "The new variable name that replaces the old one.";
    }

    @Override
    protected boolean isBaseClassMatch(Class cls) {
        return cls.equals(VariableName.class);
    }

    @Override
    public boolean canRecurse(Class cls) {
        return !cls.equals(LocalScope.class) && !cls.equals(Flow.class);
    }

    @Override
    protected boolean canProcessClassOptions() {
        return true;
    }

    @Override
    protected boolean isNameMatch(VariableName old, String oldName) {
        return old.getValue().equals(oldName);
    }

    @Override
    protected VariableName getReplacement(VariableName old, String newName) {
        return new VariableName(newName);
    }

    protected boolean processBaseObject(AbstractArgumentOption option) {
        boolean result = false;
        String oldName = Variables.padName(this.m_OldName);
        String newName = Variables.padName(this.m_NewName);
        if (option.isMultiple()) {
            Object array = option.getCurrentValue();
            boolean modified = false;
            for (int i = 0; i < Array.getLength(array); ++i) {
                BaseObject obj = (BaseObject)Array.get(array, i);
                if (obj.getValue().indexOf(oldName) <= -1) continue;
                modified = true;
                obj = BaseObject.newInstance(option.getBaseClass(), obj.getValue().replace(oldName, newName));
                Array.set(array, i, obj);
            }
            if (modified) {
                try {
                    Method method = option.getDescriptor().getWriteMethod();
                    method.invoke((Object)option.getOptionHandler(), array);
                    result = true;
                }
                catch (Exception e) {
                    System.err.println("Failed to update variable names in option " + option.getProperty() + "!");
                    e.printStackTrace();
                }
            }
        } else {
            BaseObject obj = (BaseObject)option.getCurrentValue();
            if (obj.getValue().indexOf(oldName) > -1) {
                obj = BaseObject.newInstance(option.getBaseClass(), obj.getValue().replace(oldName, newName));
                try {
                    Method method = option.getDescriptor().getWriteMethod();
                    method.invoke((Object)option.getOptionHandler(), obj);
                    result = true;
                }
                catch (Exception e) {
                    System.err.println("Failed to update variable names in option " + option.getProperty() + "!");
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    @Override
    protected void processArgumentOption(AbstractArgumentOption option) {
        super.processArgumentOption(option);
        if (option.isVariableAttached() && option.getVariableName().equals(this.m_OldName)) {
            option.setVariable(this.m_NewName);
            this.m_Modified = true;
        } else if (ClassLocator.isSubclass(BaseObject.class, option.getBaseClass())) {
            this.m_Modified |= this.processBaseObject(option);
        }
    }
}

