/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.VariableNameNoUpdate;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.flow.core.InputConsumer;
import adams.flow.core.Token;
import adams.flow.sink.AbstractDisplay;
import adams.flow.sink.ComponentSupplier;
import adams.flow.sink.DisplayPanel;
import adams.flow.sink.DisplayPanelProvider;
import adams.flow.sink.ImageViewer;
import adams.flow.sink.MergeableDisplayPanel;
import adams.flow.sink.TextSupplier;
import adams.gui.chooser.TextFileChooser;
import adams.gui.core.AbstractNamedHistoryPanel;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.BaseStatusBar;
import adams.gui.core.ExtensionFileFilter;
import adams.gui.core.GUIHelper;
import adams.gui.core.MenuBarProvider;
import adams.gui.print.JComponentWriter;
import adams.gui.print.JComponentWriterFileChooser;
import adams.gui.print.PNGWriter;
import adams.gui.sendto.SendToActionSupporter;
import adams.gui.sendto.SendToActionUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DisplayPanelManager
extends AbstractDisplay
implements MenuBarProvider,
ComponentSupplier,
TextSupplier,
SendToActionSupporter {
    private static final long serialVersionUID = 3365817040968234289L;
    public static final String BACKUP_CURRENTCOUNT = "current count";
    public static final String BACKUP_CURRENTPANEL = "current panel";
    protected HistorySplitPanel m_HistoryPanel;
    protected DisplayPanelProvider m_PanelProvider;
    protected VariableNameNoUpdate m_EntryNameVariable;
    protected int m_NumTokens;
    protected JMenuBar m_MenuBar;
    protected JMenuItem m_MenuItemFileClear;
    protected JMenuItem m_MenuItemFileSaveAs;
    protected JMenuItem m_MenuItemFileClose;
    protected transient JComponentWriterFileChooser m_ComponentFileChooser;
    protected transient TextFileChooser m_TextFileChooser;
    protected int m_CurrentCount;
    protected DisplayPanel m_CurrentPanel;
    protected boolean m_AllowMerge;
    protected boolean m_AllowSearch;

    @Override
    public String globalInfo() {
        return "Actor that displays a 'history' of panels created by the selected panel provider. The provider can be an actor that generates classifier errors, for instance.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("provider", "panelProvider", new ImageViewer());
        this.m_OptionManager.add("num-tokens", "numTokens", 1, -1, null);
        this.m_OptionManager.add("entry-name-variable", "entryNameVariable", new VariableNameNoUpdate("entryNameVariable"));
        this.m_OptionManager.add("allow-merge", "allowMerge", false);
        this.m_OptionManager.add("allow-search", "allowSearch", false);
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_CurrentCount = 0;
        this.m_CurrentPanel = null;
    }

    @Override
    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_CURRENTCOUNT);
        this.pruneBackup(BACKUP_CURRENTPANEL);
    }

    @Override
    protected Hashtable<String, Object> backupState() {
        Hashtable<String, Object> result = super.backupState();
        result.put(BACKUP_CURRENTCOUNT, this.m_CurrentCount);
        if (this.m_CurrentPanel != null) {
            result.put(BACKUP_CURRENTPANEL, this.m_CurrentPanel);
        }
        return result;
    }

    @Override
    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_CURRENTCOUNT)) {
            this.m_CurrentCount = (Integer)state.get(BACKUP_CURRENTCOUNT);
            state.remove(BACKUP_CURRENTCOUNT);
        }
        if (state.containsKey(BACKUP_CURRENTPANEL)) {
            this.m_CurrentPanel = (DisplayPanel)state.get(BACKUP_CURRENTPANEL);
            state.remove(BACKUP_CURRENTPANEL);
        }
        super.restoreState(state);
    }

    @Override
    public String getQuickInfo() {
        String result = super.getQuickInfo();
        result = result + QuickInfoHelper.toString((OptionHandler)this, "panelProvider", this.m_PanelProvider, ", provider: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, "numTokens", this.m_NumTokens, ", # tokens: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, "entryNameVariable", this.m_EntryNameVariable, ", entry name var: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, "allowMerge", this.m_AllowMerge, "merge", ", ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, "allowSearch", this.m_AllowSearch, "searchable", ", ");
        return result;
    }

    @Override
    protected int getDefaultWidth() {
        return 640;
    }

    @Override
    protected int getDefaultHeight() {
        return 480;
    }

    public void setPanelProvider(DisplayPanelProvider value) {
        this.m_PanelProvider = value;
        this.reset();
    }

    public DisplayPanelProvider getPanelProvider() {
        return this.m_PanelProvider;
    }

    public String panelProviderTipText() {
        return "The actor for generating the display panels.";
    }

    public void setNumTokens(int value) {
        if (value >= -1) {
            this.m_NumTokens = value;
            this.reset();
        } else {
            this.getLogger().warning("Number of tokens must be -1/0 (for unlimited) or greater than 0, provided: " + value);
        }
    }

    public int getNumTokens() {
        return this.m_NumTokens;
    }

    public String numTokensTipText() {
        return "The number of tokens to accept per created panel.";
    }

    public void setEntryNameVariable(VariableNameNoUpdate value) {
        this.m_EntryNameVariable = value;
        this.reset();
    }

    public VariableNameNoUpdate getEntryNameVariable() {
        return this.m_EntryNameVariable;
    }

    public String entryNameVariableTipText() {
        return "The variable to use for naming the entries; gets ignored if variable not available; an existing history entry gets replaced if a new one with the same name gets added.";
    }

    public void setAllowMerge(boolean value) {
        this.m_AllowMerge = value;
        this.reset();
    }

    public boolean getAllowMerge() {
        return this.m_AllowMerge;
    }

    public String allowMergeTipText() {
        return "If enabled and the display panel is derived from " + MergeableDisplayPanel.class.getName() + " then entries with the " + "same name (ie when using 'entryNameVariable') get merged.";
    }

    public void setAllowSearch(boolean value) {
        this.m_AllowSearch = value;
        this.reset();
    }

    public boolean getAllowSearch() {
        return this.m_AllowSearch;
    }

    public String allowSearchTipText() {
        return "Whether to allow the user to search the entries.";
    }

    protected JPanel getSelectedPanel() {
        int index;
        JPanel result = null;
        if (this.m_HistoryPanel != null && (index = this.m_HistoryPanel.getHistory().getSelectedIndex()) != -1) {
            result = (JPanel)this.m_HistoryPanel.getHistory().getEntry(index);
        }
        return result;
    }

    @Override
    public JComponent supplyComponent() {
        JPanel panel;
        JComponent result = null;
        if (this.m_PanelProvider instanceof ComponentSupplier && (panel = this.getSelectedPanel()) != null) {
            result = ((ComponentSupplier)((Object)panel)).supplyComponent();
        }
        return result;
    }

    @Override
    public ExtensionFileFilter getCustomTextFileFilter() {
        if (this.m_PanelProvider instanceof TextSupplier) {
            return ((TextSupplier)((Object)this.getSelectedPanel())).getCustomTextFileFilter();
        }
        return null;
    }

    @Override
    public String supplyText() {
        JPanel panel;
        String result = null;
        if (this.m_PanelProvider instanceof TextSupplier && (panel = this.getSelectedPanel()) != null) {
            result = ((TextSupplier)((Object)panel)).supplyText();
        }
        return result;
    }

    @Override
    public void clearPanel() {
        if (this.m_HistoryPanel != null) {
            this.m_HistoryPanel.clear();
        }
    }

    @Override
    protected BasePanel newPanel() {
        HistorySplitPanel result = new HistorySplitPanel(this);
        result.setAllowSearch(this.m_AllowSearch);
        this.m_HistoryPanel = result;
        return result;
    }

    protected JComponentWriterFileChooser getComponentFileChooser() {
        if (this.m_ComponentFileChooser == null) {
            this.m_ComponentFileChooser = new JComponentWriterFileChooser();
        }
        return this.m_ComponentFileChooser;
    }

    protected TextFileChooser getTextFileChooser() {
        if (this.m_TextFileChooser == null) {
            TextFileChooser fileChooser = new TextFileChooser();
            ExtensionFileFilter filter = null;
            if (this instanceof TextSupplier) {
                filter = this.getCustomTextFileFilter();
            }
            if (filter != null) {
                filter = ExtensionFileFilter.getTextFileFilter();
                fileChooser.resetChoosableFileFilters();
                fileChooser.addChoosableFileFilter(filter);
                fileChooser.setFileFilter(filter);
                fileChooser.setDefaultExtension(filter.getExtensions()[0]);
            }
            this.m_TextFileChooser = fileChooser;
        }
        return this.m_TextFileChooser;
    }

    @Override
    public Class[] accepts() {
        if (this.m_PanelProvider != null && this.m_PanelProvider instanceof InputConsumer) {
            return ((InputConsumer)((Object)this.m_PanelProvider)).accepts();
        }
        return new Class[]{Object.class};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void display(Token token) {
        boolean newPanel = false;
        if (this.m_NumTokens > 0 && this.m_CurrentCount % this.m_NumTokens == 0) {
            newPanel = true;
        } else if (this.m_NumTokens <= 0 && this.m_CurrentCount == 0) {
            newPanel = true;
        }
        if (newPanel) {
            HistorySplitPanel historySplitPanel = this.m_HistoryPanel;
            synchronized (historySplitPanel) {
                this.m_CurrentPanel = this.m_PanelProvider.createDisplayPanel(token);
                this.m_HistoryPanel.addResult(this.m_CurrentPanel);
            }
        } else if (this.m_CurrentPanel != null) {
            this.m_CurrentPanel.display(token);
        }
        ++this.m_CurrentCount;
    }

    protected JMenuBar createMenuBar() {
        JMenuBar result = new JMenuBar();
        JMenu menu = new JMenu("File");
        result.add(menu);
        menu.setMnemonic('F');
        menu.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                DisplayPanelManager.this.updateMenu();
            }
        });
        JMenuItem menuitem = new JMenuItem("Clear");
        menu.add(menuitem);
        menuitem.setMnemonic('l');
        menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl pressed N"));
        menuitem.setIcon(GUIHelper.getIcon("new.gif"));
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DisplayPanelManager.this.clear();
            }
        });
        this.m_MenuItemFileClear = menuitem;
        menuitem = new JMenuItem("Save as...");
        menu.add(menuitem);
        menuitem.setMnemonic('a');
        menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl pressed S"));
        menuitem.setIcon(GUIHelper.getIcon("save.gif"));
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DisplayPanelManager.this.saveAs();
            }
        });
        this.m_MenuItemFileSaveAs = menuitem;
        menu.addSeparator();
        if (SendToActionUtils.addSendToSubmenu((SendToActionSupporter)this, menu)) {
            menu.addSeparator();
        }
        menuitem = new JMenuItem("Close");
        menu.add(menuitem);
        menuitem.setMnemonic('C');
        menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl pressed Q"));
        menuitem.setIcon(GUIHelper.getIcon("exit.png"));
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DisplayPanelManager.this.close();
            }
        });
        this.m_MenuItemFileClose = menuitem;
        return result;
    }

    @Override
    public JMenuBar getMenuBar() {
        if (this.m_MenuBar == null) {
            this.m_MenuBar = this.createMenuBar();
            this.updateMenu();
        }
        return this.m_MenuBar;
    }

    protected void updateMenu() {
        if (this.m_MenuBar == null) {
            return;
        }
        this.m_MenuItemFileSaveAs.setEnabled((this.m_PanelProvider instanceof ComponentSupplier || this.m_PanelProvider instanceof TextSupplier) && this.getSelectedPanel() != null);
        this.m_MenuItemFileClear.setEnabled(this.m_HistoryPanel.count() > 0);
    }

    protected void clear() {
        this.m_HistoryPanel.clear();
    }

    protected void saveAs() {
        String filename = this.m_HistoryPanel.getHistory().getSelectedEntry();
        filename = FileUtils.createFilename(filename, "");
        if (this.m_PanelProvider instanceof TextSupplier) {
            filename = filename + "." + this.getTextFileChooser().getDefaultExtension();
            this.getTextFileChooser().setSelectedFile(new File(filename));
            int retVal = this.getTextFileChooser().showSaveDialog(this.m_HistoryPanel);
            if (retVal != 0) {
                return;
            }
            FileUtils.writeToFile(this.getTextFileChooser().getSelectedFile().getAbsolutePath(), this.supplyText(), false, this.getTextFileChooser().getEncoding());
        } else if (this.m_PanelProvider instanceof ComponentSupplier) {
            this.getComponentFileChooser().setSelectedFile(new File(filename));
            int retVal = this.getComponentFileChooser().showSaveDialog(this.m_HistoryPanel);
            if (retVal != 0) {
                return;
            }
            JComponentWriter writer = this.getComponentFileChooser().getWriter();
            writer.setComponent(this.supplyComponent());
            try {
                writer.toOutput();
            }
            catch (Exception e) {
                this.handleException("Error saving panel to '" + writer.getFile() + "': ", e);
            }
        }
    }

    protected void close() {
        this.m_HistoryPanel.closeParent();
    }

    @Override
    protected void cleanUpGUI() {
        if (this.m_HistoryPanel != null) {
            this.m_HistoryPanel.clear();
        }
        this.m_MenuBar = null;
        this.m_MenuItemFileClear = null;
        this.m_MenuItemFileSaveAs = null;
        this.m_MenuItemFileClose = null;
        super.cleanUpGUI();
    }

    @Override
    public Class[] getSendToClasses() {
        if (this.m_PanelProvider instanceof ComponentSupplier) {
            return new Class[]{PlaceholderFile.class, JComponent.class};
        }
        if (this.m_PanelProvider instanceof TextSupplier) {
            return new Class[]{String.class};
        }
        return new Class[]{String.class};
    }

    @Override
    public boolean hasSendToItem(Class[] cls) {
        if (SendToActionUtils.isAvailable(JComponent.class, cls)) {
            if (this.m_PanelProvider instanceof ComponentSupplier) {
                return this.supplyComponent() != null;
            }
            return false;
        }
        if (SendToActionUtils.isAvailable(new Class[]{PlaceholderFile.class, String.class}, cls)) {
            if (this.m_PanelProvider instanceof ComponentSupplier) {
                return this.supplyComponent() != null;
            }
            if (this.m_PanelProvider instanceof TextSupplier) {
                return this.supplyText() != null && this.supplyText().length() > 0;
            }
        }
        return false;
    }

    @Override
    public Object getSendToItem(Class[] cls) {
        Object result = null;
        if (SendToActionUtils.isAvailable(new Class[]{PlaceholderFile.class, String.class}, cls)) {
            JComponent comp;
            if (this.m_PanelProvider instanceof ComponentSupplier && (comp = this.supplyComponent()) != null) {
                result = SendToActionUtils.nextTmpFile("actor-" + this.getName(), "png");
                PNGWriter writer = new PNGWriter();
                writer.setFile((PlaceholderFile)result);
                writer.setComponent(comp);
                try {
                    writer.generateOutput();
                }
                catch (Exception e) {
                    this.handleException("Failed to write image to " + result + ":", e);
                    result = null;
                }
            }
            if (this.m_PanelProvider instanceof TextSupplier) {
                result = this.supplyText();
            }
        } else if (SendToActionUtils.isAvailable(JComponent.class, cls) && this.m_PanelProvider instanceof ComponentSupplier) {
            result = this.supplyComponent();
        }
        return result;
    }

    public static class HistorySplitPanel
    extends BasePanel {
        private static final long serialVersionUID = 5121061351955687610L;
        protected DisplayPanelManager m_Owner;
        protected JSplitPane m_SplitPane;
        protected BaseStatusBar m_StatusBar;
        protected DisplayPanelHistoryPanel m_History;
        protected BasePanel m_Panel;
        protected SimpleDateFormat m_Format;

        public HistorySplitPanel(DisplayPanelManager owner) {
            super(new BorderLayout());
            this.m_Owner = owner;
            this.m_Format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            this.m_SplitPane = new JSplitPane();
            this.add((Component)this.m_SplitPane, "Center");
            this.m_Panel = new BasePanel(new BorderLayout());
            if (owner.getPanelProvider().displayPanelRequiresScrollPane()) {
                this.m_SplitPane.setBottomComponent(new BaseScrollPane(this.m_Panel));
            } else {
                this.m_SplitPane.setBottomComponent(this.m_Panel);
            }
            this.m_History = new DisplayPanelHistoryPanel();
            this.m_History.setPanel(this.m_Panel);
            this.m_History.addHistoryEntrySelectionListener(new AbstractNamedHistoryPanel.HistoryEntrySelectionListener(){

                @Override
                public void historyEntrySelected(AbstractNamedHistoryPanel.HistoryEntrySelectionEvent e) {
                    HistorySplitPanel.this.m_StatusBar.setStatus(Utils.flatten(e.getNames(), ", "));
                }
            });
            this.m_SplitPane.setTopComponent(this.m_History);
            this.m_SplitPane.setResizeWeight(0.1);
            this.m_SplitPane.setDividerLocation(Math.max(150, this.m_History.getPreferredSize().width));
            this.m_StatusBar = new BaseStatusBar();
            this.m_StatusBar.setMouseListenerActive(true);
            this.add((Component)this.m_StatusBar, "South");
        }

        public DisplayPanelManager getOwner() {
            return this.m_Owner;
        }

        public void clear() {
            this.m_History.clear();
            this.m_Panel.removeAll();
            this.m_Panel.repaint();
        }

        public int count() {
            return this.m_History.count();
        }

        public DisplayPanelHistoryPanel getHistory() {
            return this.m_History;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void addResult(DisplayPanel result) {
            String id;
            String var = this.m_Owner.getEntryNameVariable().getValue();
            if (this.m_Owner.getVariables().has(var)) {
                id = this.m_Owner.getVariables().get(var);
            } else {
                String baseID;
                SimpleDateFormat simpleDateFormat = this.m_Format;
                synchronized (simpleDateFormat) {
                    baseID = this.m_Format.format(new Date());
                }
                id = this.m_History.newEntryName(baseID);
            }
            boolean add = true;
            if (this.m_History.hasEntry(id) && this.m_Owner.getAllowMerge()) {
                if (result instanceof MergeableDisplayPanel) {
                    ((MergeableDisplayPanel)this.m_History.getEntry(id)).mergeWith((MergeableDisplayPanel)result);
                    add = false;
                } else {
                    this.m_Owner.getLogger().warning(result.getClass().getName() + " does not implement " + MergeableDisplayPanel.class.getName() + ", merging not possible!");
                }
            }
            if (add) {
                this.m_History.addEntry(id, result);
            }
            this.m_History.setSelectedEntry(id);
        }

        public void setAllowSearch(boolean value) {
            this.m_History.setAllowSearch(value);
        }

        public boolean getAllowSearch() {
            return this.m_History.getAllowSearch();
        }
    }

    public static class DisplayPanelHistoryPanel
    extends AbstractNamedHistoryPanel<DisplayPanel> {
        private static final long serialVersionUID = 1704390033157269580L;
        protected BasePanel m_Panel;

        @Override
        protected void initialize() {
            super.initialize();
            this.m_Panel = null;
        }

        public void setPanel(BasePanel value) {
            this.m_Panel = value;
        }

        @Override
        protected void updateEntry(String name) {
            this.m_Panel.removeAll();
            if (name != null && this.hasEntry(name)) {
                this.m_Panel.add((JPanel)this.getEntry(name));
                this.m_Panel.getParent().invalidate();
                this.m_Panel.getParent().validate();
                this.m_Panel.getParent().repaint();
            }
        }

        @Override
        public DisplayPanel removeEntry(String name) {
            DisplayPanel result = (DisplayPanel)super.removeEntry(name);
            if (result != null) {
                result.cleanUp();
            }
            return result;
        }
    }
}

