/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.db.AbstractDatabaseConnection;
import adams.db.LogEntry;
import adams.db.LogT;
import adams.flow.core.ActorUtils;
import adams.flow.sink.AbstractSink;
import adams.flow.standalone.DatabaseConnection;

public class Logger
extends AbstractSink {
    private static final long serialVersionUID = 1862024453539320530L;
    protected AbstractDatabaseConnection m_DatabaseConnection;

    @Override
    public String globalInfo() {
        return "Actor that stores LogEntry objects in the Log table.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{LogEntry.class};
    }

    @Override
    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            this.m_DatabaseConnection = ActorUtils.getDatabaseConnection(this, DatabaseConnection.class, adams.db.DatabaseConnection.getSingleton());
            if (!this.m_DatabaseConnection.isConnected()) {
                result = "No active database connection available!";
            }
        }
        return result;
    }

    @Override
    protected String doExecute() {
        String result = null;
        LogEntry log = (LogEntry)this.m_InputToken.getPayload();
        if (!LogT.getSingleton(this.m_DatabaseConnection).add(log)) {
            result = "Failed to add log entry:\n" + log;
        }
        return result;
    }

    @Override
    public void wrapUp() {
        this.m_DatabaseConnection = null;
        super.wrapUp();
    }
}

