/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.flow.core.Token;
import adams.flow.sink.AbstractTextDisplayPanel;
import adams.flow.sink.AbstractTextualDisplay;
import adams.flow.sink.DisplayPanel;
import adams.flow.sink.DisplayPanelProvider;
import adams.flow.sink.TextSupplier;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.ExtensionFileFilter;
import adams.gui.core.PropertiesTableModel;
import adams.gui.core.SearchPanel;
import adams.gui.core.SortableAndSearchableTable;
import adams.gui.event.SearchEvent;
import adams.gui.event.SearchListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Properties;

public class PropertiesDisplay
extends AbstractTextualDisplay
implements DisplayPanelProvider,
TextSupplier {
    private static final long serialVersionUID = 680299970232233254L;
    protected SortableAndSearchableTable m_Table;
    protected PropertiesTableModel m_Model;
    protected SearchPanel m_PanelSearch;

    @Override
    public String globalInfo() {
        return "Displays a Properties object as table.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Properties.class};
    }

    @Override
    protected void display(Token token) {
        this.m_Model = new PropertiesTableModel((Properties)token.getPayload());
        this.m_Table.setModel(this.m_Model);
    }

    @Override
    public void clearPanel() {
        this.m_Model = new PropertiesTableModel();
        this.m_Table.setModel(this.m_Model);
    }

    @Override
    protected BasePanel newPanel() {
        BasePanel result = new BasePanel(new BorderLayout());
        this.m_Model = new PropertiesTableModel();
        this.m_Table = new SortableAndSearchableTable(this.m_Model);
        result.add((Component)new BaseScrollPane(this.m_Table), "Center");
        this.m_PanelSearch = new SearchPanel(SearchPanel.LayoutType.HORIZONTAL, true);
        this.m_PanelSearch.addSearchListener(new SearchListener(){

            @Override
            public void searchInitiated(SearchEvent e) {
                PropertiesDisplay.this.m_Table.search(e.getParameters().getSearchString(), e.getParameters().isRegExp());
            }
        });
        result.add((Component)this.m_PanelSearch, "South");
        return result;
    }

    @Override
    public ExtensionFileFilter getCustomTextFileFilter() {
        return new ExtensionFileFilter("XML", "xml");
    }

    @Override
    public String supplyText() {
        String result = null;
        if (this.m_Model != null) {
            result = this.m_Model.getProperties().toStringSimple();
        }
        return result;
    }

    @Override
    public DisplayPanel createDisplayPanel(Token token) {
        AbstractTextDisplayPanel result = new AbstractTextDisplayPanel("PropertiesDisplay"){
            private static final long serialVersionUID = 4356468458332186521L;
            protected SortableAndSearchableTable m_Table;
            protected PropertiesTableModel m_Model;
            protected SearchPanel m_PanelSearch;

            @Override
            protected void initGUI() {
                super.initGUI();
                this.m_Model = new PropertiesTableModel();
                this.m_Table = new SortableAndSearchableTable(this.m_Model);
                this.add((Component)new BaseScrollPane(this.m_Table), "Center");
                this.m_PanelSearch = new SearchPanel(SearchPanel.LayoutType.HORIZONTAL, true);
                this.m_PanelSearch.addSearchListener(new SearchListener(){

                    @Override
                    public void searchInitiated(SearchEvent e) {
                        m_Table.search(e.getParameters().getSearchString(), e.getParameters().isRegExp());
                    }
                });
                this.add((Component)this.m_PanelSearch, "South");
            }

            @Override
            public void display(Token token) {
                this.m_Model = new PropertiesTableModel((Properties)token.getPayload());
                this.m_Table.setModel(this.m_Model);
            }

            @Override
            public void clearPanel() {
                this.m_Model = new PropertiesTableModel();
                this.m_Table.setModel(this.m_Model);
            }

            @Override
            public void cleanUp() {
            }

            @Override
            public ExtensionFileFilter getCustomTextFileFilter() {
                return new ExtensionFileFilter("Properties", new String[]{"props", "properties"});
            }

            @Override
            public String supplyText() {
                if (this.m_Model != null) {
                    return this.m_Model.getProperties().toStringSimple();
                }
                return null;
            }
        };
        result.display(token);
        return result;
    }

    @Override
    public boolean displayPanelRequiresScrollPane() {
        return false;
    }
}

