/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.flow.sink.AbstractFileWriter;
import java.io.PrintStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;

public class XMLFileWriter
extends AbstractFileWriter {
    private static final long serialVersionUID = 3613018887562327088L;

    @Override
    public String globalInfo() {
        return "Writes a " + Document.class.getName() + " to an XML file.";
    }

    @Override
    public String outputFileTipText() {
        return "The name of the output file.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Document.class};
    }

    @Override
    protected String doExecute() {
        String result = null;
        try {
            DOMSource dsource = new DOMSource((Document)this.m_InputToken.getPayload());
            PrintStream pstream = new PrintStream(this.m_OutputFile.getAbsolutePath());
            StreamResult sresult = new StreamResult(pstream);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.transform(dsource, sresult);
        }
        catch (Exception e) {
            result = this.handleException("Failed to write DOM document to " + this.m_OutputFile, e);
        }
        return result;
    }
}

