/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink.sequenceplotter;

import adams.core.NamedCounter;
import adams.flow.container.SequencePlotterContainer;
import adams.flow.sink.sequenceplotter.AbstractPlotUpdater;
import adams.flow.sink.sequenceplotter.SequencePlotterPanel;

public class NamedPlotUpdater
extends AbstractPlotUpdater {
    private static final long serialVersionUID = 4418135588639219439L;
    protected int m_UpdateInterval;
    protected NamedCounter m_NumTokensAccepted;

    @Override
    public String globalInfo() {
        return "Updates the flow after the specified number of tokens per named plot have been processed.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("update-interval", "updateInterval", 1, 1, null);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_NumTokensAccepted = new NamedCounter();
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_NumTokensAccepted.clear();
    }

    public void setUpdateInterval(int value) {
        if (value >= 1) {
            this.m_UpdateInterval = value;
            this.reset();
        } else {
            this.getLogger().severe("Update interval must be >= 1, provided: " + value);
        }
    }

    public int getUpdateInterval() {
        return this.m_UpdateInterval;
    }

    public String updateIntervalTipText() {
        return "Specifies the number of tokens per plot after which the display is being updated (markers excluded).";
    }

    @Override
    protected boolean canNotify(SequencePlotterPanel plotter, SequencePlotterContainer cont) {
        boolean result = false;
        String plotName = (String)cont.getValue("PlotName");
        SequencePlotterContainer.ContentType type = (SequencePlotterContainer.ContentType)((Object)cont.getValue("Content type"));
        if (type == SequencePlotterContainer.ContentType.PLOT) {
            this.m_NumTokensAccepted.next(plotName);
        }
        if (this.m_NumTokensAccepted.hasReached(plotName, this.m_UpdateInterval)) {
            this.m_NumTokensAccepted.clear(plotName);
            result = true;
        }
        return result;
    }
}

