/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.QuickInfoHelper;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.flow.source.AbstractArrayProvider;
import java.util.ArrayList;

public class FileSupplier
extends AbstractArrayProvider {
    private static final long serialVersionUID = -8288435835502863891L;
    protected PlaceholderFile[] m_Files;

    @Override
    public String globalInfo() {
        return "Supplies files.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("file", "files", new PlaceholderFile[0]);
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, "files", this.m_Files.length == 1 ? this.m_Files[0] : this.m_Files.length + " files");
        String value = QuickInfoHelper.toString((OptionHandler)this, "outputArray", this.m_OutputArray, "output as array", ", ");
        if (value != null) {
            result = result + value;
        }
        return result;
    }

    @Override
    protected Class getItemClass() {
        return String.class;
    }

    public void setFiles(PlaceholderFile[] value) {
        this.m_Files = value;
        this.reset();
    }

    public PlaceholderFile[] getFiles() {
        return this.m_Files;
    }

    public String filesTipText() {
        return "The files to supply.";
    }

    @Override
    public String outputArrayTipText() {
        return "Whether to return the files as array or one by one.";
    }

    @Override
    protected String doExecute() {
        this.m_Queue = new ArrayList();
        for (PlaceholderFile file : this.m_Files) {
            this.m_Queue.add(file.getAbsolutePath());
        }
        return null;
    }
}

