/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.QuickInfoHelper;
import adams.core.base.BaseRegExp;
import adams.core.option.OptionHandler;
import adams.flow.control.StorageName;
import adams.flow.source.AbstractArrayProvider;
import java.util.Collections;
import java.util.Set;

public class ListStorageNames
extends AbstractArrayProvider {
    private static final long serialVersionUID = -3232942192233897676L;
    protected String m_Cache;
    protected BaseRegExp m_RegExp;
    protected boolean m_Invert;

    @Override
    public String globalInfo() {
        return "Outputs the names of the currently available storage items.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("cache", "cache", "");
        this.m_OptionManager.add("regexp", "regExp", new BaseRegExp(".*"));
        this.m_OptionManager.add("invert", "invert", false);
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, "regExp", this.m_RegExp, this.m_Invert ? "! " : "");
    }

    @Override
    protected Class getItemClass() {
        return String.class;
    }

    @Override
    public String outputArrayTipText() {
        return "Whether to output the storage item names in an array rather than one by one.";
    }

    public void setCache(String value) {
        this.m_Cache = value;
        this.reset();
    }

    public String getCache() {
        return this.m_Cache;
    }

    public String cacheTipText() {
        return "The name of the cache to retrieve the storage item names; uses the regular storage if left empty.";
    }

    public void setRegExp(BaseRegExp value) {
        this.m_RegExp = value;
        this.reset();
    }

    public BaseRegExp getRegExp() {
        return this.m_RegExp;
    }

    public String regExpTipText() {
        return "The regular expression used for matching the storage item names.";
    }

    public void setInvert(boolean value) {
        this.m_Invert = value;
        this.reset();
    }

    public boolean getInvert() {
        return this.m_Invert;
    }

    public String invertTipText() {
        return "If set to true, then the matching sense is inverted.";
    }

    @Override
    public Class[] generates() {
        return new Class[]{String.class};
    }

    @Override
    protected String doExecute() {
        this.m_Queue.clear();
        Set<StorageName> set = this.m_Cache.length() > 0 ? this.getStorageHandler().getStorage().keySet(this.m_Cache) : this.getStorageHandler().getStorage().keySet();
        if (this.m_RegExp.isMatchAll()) {
            if (!this.m_Invert) {
                for (StorageName sname : set) {
                    String name = sname.getValue();
                    this.m_Queue.add(name);
                }
            }
        } else {
            for (StorageName sname : set) {
                String name = sname.getValue();
                if (this.m_Invert && !this.m_RegExp.isMatch(name)) {
                    this.m_Queue.add(name);
                    continue;
                }
                if (this.m_Invert || !this.m_RegExp.isMatch(name)) continue;
                this.m_Queue.add(name);
            }
        }
        Collections.sort(this.m_Queue);
        return null;
    }
}

