/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.QuickInfoHelper;
import adams.core.VariableName;
import adams.core.VariableUser;
import adams.core.option.OptionHandler;
import adams.flow.core.Token;
import adams.flow.source.AbstractSimpleSource;

public class Variable
extends AbstractSimpleSource
implements VariableUser {
    private static final long serialVersionUID = -7838881435448178095L;
    protected VariableName m_VariableName;
    protected String m_VariableValue;

    @Override
    public String globalInfo() {
        return "Outputs the string value of the specified variable.\nDoes nothing if the variable hasn't been set.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("var-name", "variableName", new VariableName());
    }

    public void setVariableName(VariableName value) {
        this.m_VariableName = value;
        this.reset();
    }

    public VariableName getVariableName() {
        return this.m_VariableName;
    }

    public String variableNameTipText() {
        return "The name of the variable to update.";
    }

    @Override
    public boolean isUsingVariables() {
        return !this.getSkip();
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, "variableName", this.m_VariableName.paddedValue());
    }

    @Override
    public Class[] generates() {
        return new Class[]{String.class};
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_VariableValue = null;
    }

    @Override
    protected String doExecute() {
        String result = null;
        this.m_VariableValue = this.getVariables().has(this.m_VariableName.getValue()) ? this.getVariables().get(this.m_VariableName.getValue()) : null;
        if (this.m_VariableValue != null) {
            this.m_OutputToken = new Token(this.m_VariableValue);
        }
        return result;
    }
}

