/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone;

import adams.flow.control.AbstractDirector;
import adams.flow.control.MutableControlActor;
import adams.flow.core.ActorExecution;
import adams.flow.core.ActorHandlerInfo;
import adams.flow.core.GlobalActorHandler;
import java.util.HashSet;

public class GlobalActors
extends MutableControlActor
implements GlobalActorHandler {
    private static final long serialVersionUID = -5282103315016094476L;

    @Override
    public String globalInfo() {
        return "Container for actors that need to be accessed globally via their name.";
    }

    @Override
    protected AbstractDirector newDirector() {
        return new GlobalActorsDirector();
    }

    @Override
    public String actorsTipText() {
        return "All the actors that are to be accessed globally via their name.";
    }

    @Override
    public ActorHandlerInfo getActorHandlerInfo() {
        return new ActorHandlerInfo(true, ActorExecution.UNDEFINED, false);
    }

    protected String checkNames() {
        String result = null;
        HashSet<String> names = new HashSet<String>();
        for (int i = 0; i < this.size(); ++i) {
            if (names.contains(this.get(i).getName())) {
                result = "Actor '" + this.get(i).getFullName() + "' has duplicate name '" + this.get(i).getName() + "'!";
                break;
            }
            if (this.getScopeHandler() != null) {
                result = this.getScopeHandler().addGlobalName(this.get(i).getName());
            }
            if (result != null) break;
            names.add(this.get(i).getName());
        }
        return result;
    }

    @Override
    public String check() {
        return this.checkNames();
    }

    @Override
    protected String doExecute() {
        return null;
    }

    @Override
    public void wrapUp() {
        for (int i = 0; i < this.size(); ++i) {
            this.get(i).wrapUp();
        }
        super.wrapUp();
    }

    public static class GlobalActorsDirector
    extends AbstractDirector {
        private static final long serialVersionUID = -7581710637774405432L;

        @Override
        public String execute() {
            return null;
        }
    }
}

