/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.report.AbstractField;
import adams.data.report.Field;
import adams.data.report.MutableReportHandler;
import adams.data.report.Report;
import adams.data.report.ReportHandler;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;

public abstract class AbstractSetReportValue
extends AbstractTransformer {
    private static final long serialVersionUID = -5937471470417243026L;
    protected AbstractField m_Field;
    protected String m_Value;

    @Override
    public abstract String globalInfo();

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("field", "field", this.getDefaultField());
        this.m_OptionManager.add("value", "value", "");
    }

    protected abstract AbstractField getDefaultField();

    public void setValue(String value) {
        this.m_Value = value;
        this.reset();
    }

    public String getValue() {
        return this.m_Value;
    }

    public abstract String valueTipText();

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, "field", this.m_Field.toParseableString());
        result = result + QuickInfoHelper.toString((OptionHandler)this, "value", "'" + this.m_Value + "'", " -> ");
        return result;
    }

    @Override
    public abstract Class[] accepts();

    @Override
    public abstract Class[] generates();

    protected abstract Report newReport();

    @Override
    protected String doExecute() {
        String result = null;
        Report report = this.m_InputToken.getPayload() instanceof ReportHandler ? ((ReportHandler)this.m_InputToken.getPayload()).getReport() : (Report)this.m_InputToken.getPayload();
        try {
            if (report == null && this.m_InputToken.getPayload() instanceof MutableReportHandler) {
                report = this.newReport();
                ((MutableReportHandler)this.m_InputToken.getPayload()).setReport(report);
            }
            if (report != null) {
                Field field = new Field(this.m_Field);
                report.addField(field);
                report.addParameter(this.m_Field.getName(), this.m_Value);
            } else if (this.isLoggingEnabled()) {
                this.getLogger().info("No report available: " + this.m_InputToken);
            }
        }
        catch (Exception e) {
            result = this.handleException("Failed to set report value: " + this.m_Field + "/" + this.m_Value, e);
        }
        this.m_OutputToken = new Token(this.m_InputToken.getPayload());
        return result;
    }
}

