/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.io.File;
import java.io.FileInputStream;
import java.util.Hashtable;

public class BinaryFileReader
extends AbstractTransformer {
    private static final long serialVersionUID = 6525019504599945776L;
    public static final String BACKUP_POSITION = "position";
    public static final String BACKUP_STREAM = "stream";
    public static final String BACKUP_FILE = "file";
    protected long m_Start;
    protected long m_End;
    protected long m_Position;
    protected long m_ActualEnd;
    protected transient FileInputStream m_Stream;
    protected File m_CurrentFile;

    @Override
    public String globalInfo() {
        return "Reads a binary file and forwards the content byte by byte.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("start", "start", 1L, 1L, null);
        this.m_OptionManager.add("end", "end", -1L, -1L, null);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Position = 0L;
        this.m_Stream = null;
        this.m_CurrentFile = null;
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_Position = 0L;
        this.m_Stream = null;
        this.m_CurrentFile = null;
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, "start", this.m_Start, "from: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, "start", this.m_End > 0L ? Long.valueOf(this.m_End) : "EOF", ", to: ");
        return result;
    }

    @Override
    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_POSITION);
        this.pruneBackup(BACKUP_STREAM);
        this.pruneBackup(BACKUP_FILE);
    }

    @Override
    protected Hashtable<String, Object> backupState() {
        Hashtable<String, Object> result = super.backupState();
        if (this.m_Position > 0L) {
            result.put(BACKUP_POSITION, this.m_Position);
        }
        if (this.m_Stream != null) {
            result.put(BACKUP_STREAM, this.m_Stream);
        }
        if (this.m_CurrentFile != null) {
            result.put(BACKUP_FILE, this.m_CurrentFile);
        }
        return result;
    }

    @Override
    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_POSITION)) {
            this.m_Position = (Long)state.get(BACKUP_POSITION);
            state.remove(BACKUP_POSITION);
        }
        if (state.containsKey(BACKUP_STREAM)) {
            this.m_Stream = (FileInputStream)state.get(BACKUP_STREAM);
            state.remove(BACKUP_STREAM);
        }
        if (state.containsKey(BACKUP_FILE)) {
            this.m_CurrentFile = (File)state.get(BACKUP_FILE);
            state.remove(BACKUP_FILE);
        }
        super.restoreState(state);
    }

    public void setStart(long value) {
        this.m_Start = value;
        this.reset();
    }

    public long getStart() {
        return this.m_Start;
    }

    public String startTipText() {
        return "The starting position in the file (1-based index).";
    }

    public void setEnd(long value) {
        this.m_End = value;
        this.reset();
    }

    public long getEnd() {
        return this.m_End;
    }

    public String endTipText() {
        return "The last position in the file (incl; 1-based index; <0 denotes end-of-file).";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{String.class, File.class};
    }

    @Override
    public Class[] generates() {
        return new Class[]{Byte.class};
    }

    @Override
    protected String doExecute() {
        String result = null;
        Object fileObj = this.m_InputToken.getPayload();
        File file = fileObj instanceof File ? (File)fileObj : new PlaceholderFile((String)fileObj);
        try {
            this.m_Stream = new FileInputStream(file.getAbsolutePath());
            this.m_ActualEnd = this.m_End > 0L ? Math.min(this.m_End, file.length()) : file.length();
            if (this.m_Start > this.m_ActualEnd) {
                result = "Start position is after end position: " + this.m_Start + " < " + this.m_ActualEnd;
            } else {
                this.m_CurrentFile = file;
                this.m_Position = this.m_Start - 1L;
                if (this.m_Position > 0L) {
                    this.m_Stream.skip(this.m_Position);
                }
            }
        }
        catch (Exception e) {
            result = this.handleException("Failed to open file '" + file + "':", e);
            this.m_ActualEnd = 0L;
            this.m_CurrentFile = null;
        }
        return result;
    }

    protected void closeStream() {
        if (this.m_Stream == null) {
            return;
        }
        try {
            this.m_Stream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_CurrentFile = null;
    }

    @Override
    public boolean hasPendingOutput() {
        return this.m_CurrentFile != null && this.m_Position < this.m_ActualEnd;
    }

    @Override
    public Token output() {
        Token result;
        try {
            int c = this.m_Stream.read();
            if (c != -1) {
                result = new Token((byte)c);
                ++this.m_Position;
            } else {
                result = null;
                this.m_Position = this.m_ActualEnd;
                this.closeStream();
            }
        }
        catch (Exception e) {
            this.handleException("Failed to read from file '" + this.m_CurrentFile + "':", e);
            result = null;
        }
        return result;
    }

    @Override
    public void wrapUp() {
        this.closeStream();
        super.wrapUp();
    }
}

