/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.ClassCrossReference;
import adams.core.QuickInfoHelper;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import adams.flow.transformer.AppendName;
import adams.flow.transformer.BaseName;
import adams.flow.transformer.DirName;
import adams.flow.transformer.PrependDir;
import java.io.File;

public class FileExtension
extends AbstractTransformer
implements ClassCrossReference {
    private static final long serialVersionUID = -2838258525424174583L;
    protected boolean m_IncludeDot;

    @Override
    public String globalInfo() {
        return "Extracts the file extension from the file (the part after the '.').\nIf no dot is in the file name, then an empty string gets forwarded.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("include-dot", "includeDot", false);
    }

    public void setIncludeDot(boolean value) {
        this.m_IncludeDot = value;
        this.reset();
    }

    public boolean getIncludeDot() {
        return this.m_IncludeDot;
    }

    public String includeDotTipText() {
        return "If true, then the dot gets returned as well.";
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, "includeDot", this.m_IncludeDot, "incl. dot");
    }

    @Override
    public Class[] getClassCrossReferences() {
        return new Class[]{AppendName.class, PrependDir.class, DirName.class, BaseName.class};
    }

    @Override
    public Class[] accepts() {
        return new Class[]{String.class, String[].class, File.class, File[].class};
    }

    @Override
    public Class[] generates() {
        return new Class[]{String.class, String[].class};
    }

    @Override
    protected String doExecute() {
        int i;
        String[] strings;
        File[] files;
        String result = null;
        boolean array = false;
        if (this.m_InputToken.getPayload() instanceof File) {
            files = new File[]{new PlaceholderFile((File)this.m_InputToken.getPayload())};
        } else if (this.m_InputToken.getPayload() instanceof File[]) {
            files = (File[])this.m_InputToken.getPayload();
            array = true;
        } else if (this.m_InputToken.getPayload() instanceof String) {
            files = new File[]{new PlaceholderFile((String)this.m_InputToken.getPayload())};
        } else if (this.m_InputToken.getPayload() instanceof String[]) {
            strings = (String[])this.m_InputToken.getPayload();
            files = new File[strings.length];
            for (i = 0; i < strings.length; ++i) {
                files[i] = new PlaceholderFile(strings[i]);
            }
            array = true;
        } else {
            throw new IllegalStateException("Unhandled input type: " + this.m_InputToken.getPayload().getClass());
        }
        strings = new String[files.length];
        for (i = 0; i < files.length; ++i) {
            strings[i] = files[i].getName();
            int pos = strings[i].lastIndexOf(46);
            if (pos > -1) {
                if (this.m_IncludeDot) {
                    strings[i] = strings[i].substring(pos, strings[i].length());
                    continue;
                }
                strings[i] = strings[i].substring(pos + 1, strings[i].length());
                continue;
            }
            strings[i] = "";
        }
        this.m_OutputToken = array ? new Token(strings) : new Token(strings[0]);
        return result;
    }
}

