/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.base.BaseRegExp;
import adams.core.option.OptionHandler;
import adams.flow.transformer.AbstractArrayProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;

public class GetPropertyNames
extends AbstractArrayProvider {
    private static final long serialVersionUID = -8757919765508522198L;
    protected BaseRegExp m_RegExp;
    protected boolean m_SortKeys;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("reg-exp", "regExp", new BaseRegExp(".*"));
        this.m_OptionManager.add("sort-keys", "sortKeys", false);
    }

    @Override
    public String globalInfo() {
        return "Outputs all the keys of the properties object passing through.";
    }

    @Override
    public String outputArrayTipText() {
        return "If enabled, the keys will get output as array rather than one-by-one.";
    }

    public void setRegExp(BaseRegExp value) {
        this.m_RegExp = value;
        this.reset();
    }

    public BaseRegExp getRegExp() {
        return this.m_RegExp;
    }

    public String regExpTipText() {
        return "The regular expression that the property names must match in order to be listed.";
    }

    public void setSortKeys(boolean value) {
        this.m_SortKeys = value;
        this.reset();
    }

    public boolean getSortKeys() {
        return this.m_SortKeys;
    }

    public String sortKeysTipText() {
        return "If enabled, the keys will get sorted.";
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, "regExp", this.m_RegExp, "regexp: ");
        ArrayList<String> options = new ArrayList<String>();
        QuickInfoHelper.add(options, QuickInfoHelper.toString((OptionHandler)this, "outputArray", this.getOutputArray() ? "array" : "one-by-one"));
        QuickInfoHelper.add(options, QuickInfoHelper.toString((OptionHandler)this, "sortKeys", this.m_SortKeys, "sort keys"));
        result = result + QuickInfoHelper.flatten(options);
        return result;
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Properties.class};
    }

    @Override
    protected Class getItemClass() {
        return String.class;
    }

    @Override
    protected String doExecute() {
        String result = null;
        adams.core.Properties props = this.m_InputToken.getPayload() instanceof adams.core.Properties ? (adams.core.Properties)this.m_InputToken.getPayload() : new adams.core.Properties((Properties)this.m_InputToken.getPayload());
        if (result == null) {
            if (this.m_RegExp.isMatchAll()) {
                this.m_Queue.addAll(props.keySetAll());
            } else {
                this.m_Queue.addAll(props.keySetAll(this.m_RegExp));
            }
            if (this.m_SortKeys) {
                Collections.sort(this.m_Queue);
            }
        }
        return result;
    }
}

