/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.VariableName;
import adams.core.VariableUpdater;
import adams.core.option.OptionHandler;
import adams.flow.core.Unknown;
import adams.flow.transformer.AbstractTransformer;

public class SetVariable
extends AbstractTransformer
implements VariableUpdater {
    private static final long serialVersionUID = -3383735680425581504L;
    protected VariableName m_VariableName;
    protected String m_VariableValue;
    protected UpdateType m_UpdateType;

    @Override
    public String globalInfo() {
        return "Sets the value of a global variable. Each time a token passes through, the variable value will get updated.\nThe transformer just forwards tokens that it receives after the variable has been set.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("var-name", "variableName", new VariableName());
        this.m_OptionManager.add("var-value", "variableValue", "");
        this.m_OptionManager.add("update-type", "updateType", (Object)UpdateType.REPLACE);
    }

    public void setVariableName(VariableName value) {
        this.m_VariableName = value;
        this.reset();
    }

    public VariableName getVariableName() {
        return this.m_VariableName;
    }

    public String variableNameTipText() {
        return "The name of the variable to update.";
    }

    public void setVariableValue(String value) {
        this.m_VariableValue = value;
        this.reset();
    }

    public String getVariableValue() {
        return this.m_VariableValue;
    }

    public String variableValueTipText() {
        return "The fixed value to use instead of the current token; only used if non-empty.";
    }

    public void setUpdateType(UpdateType value) {
        this.m_UpdateType = value;
        this.reset();
    }

    public UpdateType getUpdateType() {
        return this.m_UpdateType;
    }

    public String updateTypeTipText() {
        return "Determines how to update the variable.";
    }

    @Override
    public boolean isUpdatingVariables() {
        return !this.getSkip();
    }

    @Override
    public String getQuickInfo() {
        String variable = QuickInfoHelper.getVariable(this, "variableName");
        String result = variable != null ? "@{" + variable + "}" : this.m_VariableName.paddedValue();
        String value = QuickInfoHelper.toString((OptionHandler)this, "variableValue", this.m_VariableValue, " = ");
        if (value != null) {
            result = result + value;
        }
        result = result + " (" + QuickInfoHelper.toString((OptionHandler)this, "updateType", (Object)this.m_UpdateType) + ")";
        return result;
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Unknown.class};
    }

    @Override
    protected String doExecute() {
        String result;
        block13: {
            result = null;
            try {
                String value = null;
                if (this.m_VariableValue.length() > 0) {
                    value = this.m_VariableValue;
                } else if (this.m_InputToken.getPayload() != null) {
                    value = this.m_InputToken.getPayload().toString();
                }
                if (value == null) break block13;
                String current = this.getVariables().has(this.m_VariableName.getValue()) ? this.getVariables().get(this.m_VariableName.getValue()) : "";
                switch (this.m_UpdateType) {
                    case REPLACE: {
                        this.getVariables().set(this.m_VariableName.getValue(), value);
                        if (this.isLoggingEnabled()) {
                            this.getLogger().info("Replacing variable '" + this.m_VariableName + "': " + value);
                        }
                        break;
                    }
                    case APPEND: {
                        this.getVariables().set(this.m_VariableName.getValue(), current + value);
                        if (this.isLoggingEnabled()) {
                            this.getLogger().info("Appending variable '" + this.m_VariableName + "': " + current + value);
                        }
                        break;
                    }
                    case PREPEND: {
                        this.getVariables().set(this.m_VariableName.getValue(), value + current);
                        if (this.isLoggingEnabled()) {
                            this.getLogger().info("Prepending variable '" + this.m_VariableName + "': " + value + current);
                        }
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unhandled update type: " + (Object)((Object)this.m_UpdateType));
                    }
                }
            }
            catch (Exception e) {
                result = this.handleException("Failed to update variable: " + this.m_VariableName, e);
            }
        }
        this.m_OutputToken = this.m_InputToken;
        return result;
    }

    @Override
    public Class[] generates() {
        return new Class[]{Unknown.class};
    }

    public static enum UpdateType {
        REPLACE,
        APPEND,
        PREPEND;

    }
}

