/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.application;

import adams.core.ClassLister;
import adams.core.option.OptionUtils;
import adams.gui.application.AbstractApplicationFrame;
import adams.gui.application.Initialization;

public abstract class AbstractInitialization
implements Initialization {
    private static final long serialVersionUID = -2596434986976571342L;

    @Override
    public abstract String getTitle();

    @Override
    public abstract boolean initialize(AbstractApplicationFrame var1);

    public static boolean initAll() {
        return AbstractInitialization.initAll(null);
    }

    public static boolean initAll(AbstractApplicationFrame parent) {
        String[] classes;
        boolean result = true;
        for (String cls : classes = AbstractInitialization.getInitializations()) {
            try {
                Initialization init = (Initialization)Class.forName(cls).newInstance();
                result = init.initialize(parent) || result;
            }
            catch (Exception e) {
                System.err.println("Failed to run initialization applet '" + cls + "':");
                e.printStackTrace();
            }
        }
        return result;
    }

    public static String[] getInitializations() {
        return ClassLister.getSingleton().getClassnames(Initialization.class);
    }

    public static Initialization forName(String classname, String[] options) {
        Initialization result;
        try {
            result = (Initialization)OptionUtils.forName(Initialization.class, classname, options);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }
}

