/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.chooser;

import adams.gui.chooser.BaseFileChooser;
import adams.gui.chooser.FileChooserBookmarksPanel;
import adams.gui.core.BasePanel;
import adams.gui.core.ExtensionFileFilter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.io.File;
import java.nio.charset.Charset;
import javax.swing.BorderFactory;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class TextFileChooser
extends BaseFileChooser {
    private static final long serialVersionUID = -810326731112492794L;
    protected FileEncodingPanel m_PanelEncoding;

    public TextFileChooser() {
    }

    public TextFileChooser(String currentDirectoryPath) {
        super(currentDirectoryPath);
    }

    public TextFileChooser(File currentDirectory) {
        super(currentDirectory);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_PanelEncoding = new FileEncodingPanel();
        this.m_PanelEncoding.setOwner(this);
        this.setAccessory(this.m_PanelEncoding);
        this.addChoosableFileFilter(ExtensionFileFilter.getTextFileFilter());
        this.setDefaultExtension(ExtensionFileFilter.getTextFileFilter().getExtensions()[0]);
        this.setAutoAppendExtension(true);
    }

    public boolean isValidEncoding() {
        return this.m_PanelEncoding.isValidEncoding();
    }

    public void setEncoding(String value) {
        this.m_PanelEncoding.setEncoding(value);
    }

    public String getEncoding() {
        return this.m_PanelEncoding.getEncoding();
    }

    public static class FileEncodingPanel
    extends BasePanel {
        private static final long serialVersionUID = -2064293687093129577L;
        protected FileChooserBookmarksPanel m_PanelBookmarks;
        protected JPanel m_PanelEncoding;
        protected JLabel m_LabelEncoding;
        protected JTextField m_TextEncoding;
        protected Color m_DefaultBackground;

        @Override
        protected void initialize() {
            super.initialize();
            this.m_DefaultBackground = this.getBackground();
        }

        @Override
        protected void initGUI() {
            super.initGUI();
            this.setLayout(new BorderLayout());
            this.m_PanelBookmarks = new FileChooserBookmarksPanel();
            this.m_PanelBookmarks.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            this.add((Component)this.m_PanelBookmarks, "Center");
            this.m_PanelEncoding = new JPanel(new FlowLayout(0));
            this.add((Component)this.m_PanelEncoding, "North");
            this.m_PanelEncoding.setBorder(BorderFactory.createLineBorder(this.m_DefaultBackground));
            this.m_TextEncoding = new JTextField(6);
            this.m_TextEncoding.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.checkEncoding();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.checkEncoding();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.checkEncoding();
                }

                protected void checkEncoding() {
                    Color curColor = ((LineBorder)FileEncodingPanel.this.m_PanelEncoding.getBorder()).getLineColor();
                    Color newColor = FileEncodingPanel.this.m_DefaultBackground;
                    if (!FileEncodingPanel.this.isValidEncoding()) {
                        newColor = Color.RED;
                    }
                    if (!newColor.equals(curColor)) {
                        FileEncodingPanel.this.m_PanelEncoding.setBorder(BorderFactory.createLineBorder(newColor));
                    }
                }
            });
            this.m_TextEncoding.setText("UTF-8");
            this.m_LabelEncoding = new JLabel("Encoding");
            this.m_LabelEncoding.setLabelFor(this.m_TextEncoding);
            this.m_PanelEncoding.add(this.m_LabelEncoding);
            this.m_PanelEncoding.add(this.m_TextEncoding);
        }

        public void setOwner(JFileChooser value) {
            this.m_PanelBookmarks.setOwner(value);
        }

        public JFileChooser getOwner() {
            return this.m_PanelBookmarks.getOwner();
        }

        protected boolean isValidEncoding() {
            return FileEncodingPanel.isValidEncoding(this.m_TextEncoding.getText());
        }

        public void setEncoding(String value) {
            this.m_TextEncoding.setText(value);
        }

        public String getEncoding() {
            return this.m_TextEncoding.getText();
        }

        public static boolean isValidEncoding(String value) {
            try {
                Charset.forName(value);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
    }
}

