/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core;

import adams.core.logging.LoggingHelper;
import adams.core.option.OptionUtils;
import adams.env.Environment;
import adams.gui.core.AbstractFrameWithOptionHandling;
import adams.gui.core.GUIHelper;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JWindow;

public class BaseWindow
extends JWindow {
    private static final long serialVersionUID = 6176039693692479862L;
    protected Logger m_Logger;

    public BaseWindow() {
        this.performInitialization();
    }

    protected void performInitialization() {
        this.initialize();
        this.initGUI();
        this.finishInit();
    }

    protected void initialize() {
        this.initializeLogger();
    }

    protected void initGUI() {
        if (GUIHelper.getLogoIcon() != null) {
            this.setIconImage(GUIHelper.getLogoIcon().getImage());
        }
    }

    protected void finishInit() {
        GUIHelper.setSizeAndLocation(this, this);
    }

    protected void initializeLogger() {
        this.m_Logger = LoggingHelper.getLogger(this.getClass());
    }

    public synchronized Logger getLogger() {
        if (this.m_Logger == null) {
            this.initializeLogger();
        }
        return this.m_Logger;
    }

    public boolean isLoggingEnabled() {
        return this.getLogger().getLevel() != Level.OFF;
    }

    protected void beforeShow() {
    }

    protected void afterShow() {
    }

    protected void beforeHide() {
    }

    protected void afterHide() {
    }

    @Override
    public void setVisible(boolean value) {
        if (value) {
            this.beforeShow();
        } else {
            this.beforeHide();
        }
        super.setVisible(value);
        if (value) {
            this.afterShow();
        } else {
            this.afterHide();
        }
    }

    public static BaseWindow forName(String classname) {
        BaseWindow result;
        try {
            result = (BaseWindow)OptionUtils.forName(AbstractFrameWithOptionHandling.class, classname, new String[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    public static void runWindow(Class env, Class app) {
        Environment.setEnvironmentClass(env);
        BaseWindow frameInst = BaseWindow.forName(app.getName());
        frameInst.setVisible(true);
    }
}

