/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core;

import adams.data.spreadsheet.Cell;
import adams.gui.core.SpreadSheetTable;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class SpreadSheetCellRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = -6070112998601610760L;

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component result = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        SpreadSheetTable spTable = (SpreadSheetTable)table;
        Cell cell = spTable.getCellAt(row, column);
        boolean numeric = false;
        Double numericVal = null;
        if (column == 0) {
            ((JLabel)result).setHorizontalAlignment(0);
            ((JLabel)result).setToolTipText(null);
            if (isSelected) {
                ((JLabel)result).setBackground(spTable.getSelectionBackground());
            } else {
                ((JLabel)result).setBackground(spTable.getBackground());
            }
            return result;
        }
        if (cell != null) {
            if (!(cell.isFormula() && spTable.getShowFormulas() || !(numeric = cell.isNumeric()) || !spTable.hasNegativeBackground() && !spTable.hasPositiveBackground())) {
                numericVal = cell.toDouble();
            }
            if (cell.isMissing()) {
                ((JLabel)result).setToolTipText("missing");
                if (isSelected) {
                    ((JLabel)result).setBackground(Color.GRAY);
                } else {
                    ((JLabel)result).setBackground(Color.LIGHT_GRAY);
                }
            } else {
                ((JLabel)result).setToolTipText(null);
                if (isSelected) {
                    if (numericVal != null && numericVal >= 0.0 && spTable.hasPositiveBackground()) {
                        ((JLabel)result).setBackground(spTable.getPositiveBackground().darker());
                    } else if (numericVal != null && numericVal < 0.0 && spTable.hasNegativeBackground()) {
                        ((JLabel)result).setBackground(spTable.getNegativeBackground().darker());
                    } else {
                        ((JLabel)result).setBackground(spTable.getSelectionBackground());
                    }
                } else if (numericVal != null && numericVal >= 0.0 && spTable.hasPositiveBackground()) {
                    ((JLabel)result).setBackground(spTable.getPositiveBackground());
                } else if (numericVal != null && numericVal < 0.0 && spTable.hasNegativeBackground()) {
                    ((JLabel)result).setBackground(spTable.getNegativeBackground());
                } else {
                    ((JLabel)result).setBackground(spTable.getBackground());
                }
            }
            if (numeric) {
                ((JLabel)result).setHorizontalAlignment(4);
            } else {
                ((JLabel)result).setHorizontalAlignment(2);
            }
        } else {
            ((JLabel)result).setToolTipText("missing");
            if (isSelected) {
                ((JLabel)result).setBackground(Color.GRAY);
            } else {
                ((JLabel)result).setBackground(Color.LIGHT_GRAY);
            }
        }
        return result;
    }
}

