/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core;

import adams.data.io.output.SpreadSheetWriter;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.RowComparator;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetSupporter;
import adams.gui.chooser.SpreadSheetFileChooser;
import adams.gui.core.GUIHelper;
import adams.gui.core.SortableAndSearchableTable;
import adams.gui.core.SpreadSheetCellRenderer;
import adams.gui.core.SpreadSheetTableModel;
import adams.gui.core.TableRowRange;
import adams.gui.event.PopupMenuListener;
import adams.gui.visualization.core.PopupMenuCustomizer;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class SpreadSheetTable
extends SortableAndSearchableTable
implements SpreadSheetSupporter {
    private static final long serialVersionUID = 1333317577811620786L;
    protected PopupMenuCustomizer m_HeaderPopupMenuCustomizer;
    protected PopupMenuCustomizer m_CellPopupMenuCustomizer;
    protected SpreadSheetFileChooser m_FileChooser;

    public SpreadSheetTable(SpreadSheet sheet) {
        this(new SpreadSheetTableModel(sheet));
    }

    public SpreadSheetTable(SpreadSheetTableModel model) {
        super(model);
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.m_HeaderPopupMenuCustomizer = null;
        this.m_CellPopupMenuCustomizer = null;
        this.addHeaderPopupMenuListener(new PopupMenuListener(){

            @Override
            public void showPopupMenu(MouseEvent e) {
                SpreadSheetTable.this.showHeaderPopupMenu(e);
            }
        });
        this.addCellPopupMenuListener(new PopupMenuListener(){

            @Override
            public void showPopupMenu(MouseEvent e) {
                SpreadSheetTable.this.showCellPopupMenu(e);
            }
        });
    }

    protected void setCustomCellRenderer() {
        SpreadSheetCellRenderer renderer = new SpreadSheetCellRenderer();
        TableColumnModel colModel = this.getColumnModel();
        for (int i = 0; i < this.getColumnCount(); ++i) {
            colModel.getColumn(i).setCellRenderer(renderer);
        }
    }

    @Override
    public void setModel(TableModel model) {
        super.setModel(model);
        this.setCustomCellRenderer();
    }

    @Override
    protected boolean initialUseOptimalColumnWidths() {
        return true;
    }

    @Override
    protected boolean initialSortNewTableModel() {
        return false;
    }

    @Override
    protected Class getTableModelClass() {
        return SpreadSheetTableModel.class;
    }

    @Override
    protected TableModel createDefaultDataModel() {
        return new SpreadSheetTableModel();
    }

    public Cell getCellAt(int rowIndex, int columnIndex) {
        SpreadSheetTableModel sheetmodel = (SpreadSheetTableModel)this.getUnsortedModel();
        Cell result = sheetmodel.getCellAt(this.getActualRow(rowIndex), columnIndex);
        return result;
    }

    public void setNumDecimals(int value) {
        ((SpreadSheetTableModel)this.getUnsortedModel()).setNumDecimals(value);
    }

    public int getNumDecimals() {
        return ((SpreadSheetTableModel)this.getUnsortedModel()).getNumDecimals();
    }

    @Override
    public SpreadSheet toSpreadSheet() {
        return this.toSpreadSheet(TableRowRange.ALL);
    }

    public SpreadSheet toSpreadSheet(TableRowRange range) {
        SpreadSheet result;
        SpreadSheet full = ((SpreadSheetTableModel)this.getUnsortedModel()).toSpreadSheet();
        switch (range) {
            case ALL: {
                result = full;
                break;
            }
            case SELECTED: {
                result = full.getHeader();
                int[] indices = this.getSelectedRows();
                for (int i = 0; i < indices.length; ++i) {
                    result.addRow().assign(full.getRow(this.getActualRow(indices[i])));
                }
                break;
            }
            case VISIBLE: {
                result = full.getHeader();
                for (int i = 0; i < this.getRowCount(); ++i) {
                    result.addRow().assign(full.getRow(this.getActualRow(i)));
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled row range: " + (Object)((Object)range));
            }
        }
        return result;
    }

    protected synchronized SpreadSheetFileChooser getFileChooser() {
        if (this.m_FileChooser == null) {
            this.m_FileChooser = new SpreadSheetFileChooser();
            this.m_FileChooser.setMultiSelectionEnabled(false);
        }
        return this.m_FileChooser;
    }

    protected void showHeaderPopupMenu(MouseEvent e) {
        JPopupMenu menu = new JPopupMenu();
        final int col = this.columnAtPoint(e.getPoint());
        final boolean asc = !e.isShiftDown();
        JMenuItem menuitem = asc ? new JMenuItem("Sort (asc)", GUIHelper.getIcon("sort-ascending.png")) : new JMenuItem("Sort (desc)", GUIHelper.getIcon("sort-descending.png"));
        menuitem.setEnabled(this.getShowRowColumn() && col > 0 || !this.getShowRowColumn());
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpreadSheet sheet = SpreadSheetTable.this.toSpreadSheet();
                if (SpreadSheetTable.this.getShowRowColumn()) {
                    sheet.sort(col - 1, asc);
                } else {
                    sheet.sort(col, asc);
                }
                SpreadSheetTable.this.setModel(new SpreadSheetTableModel(sheet));
            }
        });
        menu.add(menuitem);
        menuitem = new JMenuItem("Remove column", GUIHelper.getIcon("delete.gif"));
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpreadSheet sheet = SpreadSheetTable.this.toSpreadSheet();
                if (SpreadSheetTable.this.getShowRowColumn()) {
                    sheet.removeColumn(col - 1);
                } else {
                    sheet.removeColumn(col);
                }
                SpreadSheetTable.this.setModel(new SpreadSheetTableModel(sheet));
            }
        });
        menu.addSeparator();
        menu.add(menuitem);
        if (this.m_HeaderPopupMenuCustomizer != null) {
            this.m_HeaderPopupMenuCustomizer.customizePopupMenu(e, menu);
        }
        menu.show(this.getTableHeader(), e.getX(), e.getY());
    }

    protected void showCellPopupMenu(final MouseEvent e) {
        JPopupMenu menu = new JPopupMenu();
        JMenuItem menuitem = this.getSelectedRowCount() > 1 ? new JMenuItem("Copy rows") : new JMenuItem("Copy row");
        menuitem.setIcon(GUIHelper.getIcon("copy.gif"));
        menuitem.setEnabled(this.getSelectedRowCount() > 0);
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                SpreadSheetTable.this.copyToClipboard();
            }
        });
        menu.add(menuitem);
        menuitem = new JMenuItem("Copy cell");
        menuitem.setIcon(GUIHelper.getEmptyIcon());
        menuitem.setEnabled(this.getSelectedRowCount() == 1);
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                int row = SpreadSheetTable.this.rowAtPoint(e.getPoint());
                if (row == -1) {
                    return;
                }
                int col = SpreadSheetTable.this.columnAtPoint(e.getPoint());
                if (col == -1) {
                    return;
                }
                GUIHelper.copyToClipboard("" + SpreadSheetTable.this.getValueAt(row, col));
            }
        });
        menu.add(menuitem);
        JMenu submenu = new JMenu("Save");
        submenu.setIcon(GUIHelper.getIcon("save.gif"));
        menu.add(submenu);
        menuitem = new JMenuItem("Save all...");
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                SpreadSheetTable.this.saveAs(TableRowRange.ALL);
            }
        });
        submenu.add(menuitem);
        menuitem = new JMenuItem("Save selected...");
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                SpreadSheetTable.this.saveAs(TableRowRange.SELECTED);
            }
        });
        submenu.add(menuitem);
        menuitem = new JMenuItem("Save visible...");
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                SpreadSheetTable.this.saveAs(TableRowRange.VISIBLE);
            }
        });
        submenu.add(menuitem);
        menuitem = new JCheckBoxMenuItem("Show formulas");
        menuitem.setIcon(GUIHelper.getIcon("formula.png"));
        menuitem.setEnabled(this.getRowCount() > 0);
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                SpreadSheetTable.this.setShowFormulas(!SpreadSheetTable.this.getShowFormulas());
            }
        });
        menu.addSeparator();
        menu.add(menuitem);
        if (this.m_CellPopupMenuCustomizer != null) {
            this.m_CellPopupMenuCustomizer.customizePopupMenu(e, menu);
        }
        menu.show(this, e.getX(), e.getY());
    }

    public void setHeaderPopupMenuCustomizer(PopupMenuCustomizer value) {
        this.m_HeaderPopupMenuCustomizer = value;
    }

    public PopupMenuCustomizer getHeaderPopupMenuCustomizer() {
        return this.m_HeaderPopupMenuCustomizer;
    }

    public void setCellPopupMenuCustomizer(PopupMenuCustomizer value) {
        this.m_CellPopupMenuCustomizer = value;
    }

    public PopupMenuCustomizer getCellPopupMenuCustomizer() {
        return this.m_CellPopupMenuCustomizer;
    }

    public boolean hasNegativeBackground() {
        return ((SpreadSheetTableModel)this.getUnsortedModel()).hasNegativeBackground();
    }

    public void setNegativeBackground(Color value) {
        ((SpreadSheetTableModel)this.getUnsortedModel()).setNegativeBackground(value);
    }

    public Color getNegativeBackground() {
        return ((SpreadSheetTableModel)this.getUnsortedModel()).getNegativeBackground();
    }

    public boolean hasPositiveBackground() {
        return ((SpreadSheetTableModel)this.getUnsortedModel()).hasPositiveBackground();
    }

    public void setPositiveBackground(Color value) {
        ((SpreadSheetTableModel)this.getUnsortedModel()).setPositiveBackground(value);
    }

    public Color getPositiveBackground() {
        return ((SpreadSheetTableModel)this.getUnsortedModel()).getPositiveBackground();
    }

    public void setShowFormulas(boolean value) {
        ((SpreadSheetTableModel)this.getUnsortedModel()).setShowFormulas(value);
    }

    public boolean getShowFormulas() {
        return ((SpreadSheetTableModel)this.getUnsortedModel()).getShowFormulas();
    }

    public void setShowRowColumn(boolean value) {
        ((SpreadSheetTableModel)this.getUnsortedModel()).setShowRowColumn(value);
    }

    public boolean getShowRowColumn() {
        return ((SpreadSheetTableModel)this.getUnsortedModel()).getShowRowColumn();
    }

    public void sort(RowComparator comparator) {
        this.toSpreadSheet().sort(comparator);
        ((SpreadSheetTableModel)this.getUnsortedModel()).fireTableDataChanged();
    }

    protected void saveAs(TableRowRange range) {
        int retVal = this.getFileChooser().showSaveDialog(GUIHelper.getParentComponent(this));
        if (retVal != 0) {
            return;
        }
        File file = this.getFileChooser().getSelectedFile();
        SpreadSheetWriter writer = (SpreadSheetWriter)this.getFileChooser().getWriter();
        if (!writer.write(this.toSpreadSheet(range), file)) {
            GUIHelper.showErrorMessage(this, "Failed to save spreadsheet to the following file:\n" + file);
        }
    }
}

