/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core;

import adams.core.License;
import adams.core.Utils;
import adams.core.annotation.MixedCopyright;
import adams.core.io.FileUtils;
import adams.flow.sink.TextSupplier;
import adams.gui.chooser.TextFileChooser;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.BaseTextArea;
import adams.gui.core.ExtensionFileFilter;
import adams.gui.core.GUIHelper;
import adams.gui.core.MouseUtils;
import adams.gui.core.PopupMenuCustomizer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.Document;
import javax.swing.undo.UndoManager;

@MixedCopyright(copyright="Patrick Chan and Addision Wesley, Java Developers Almanac 2000", license=License.BSD3, url="http://java.sun.com/developer/codesamples/examplets/javax.swing.undo/236.html", note="Undo/redo")
public class TextEditorPanel
extends BasePanel
implements TextSupplier {
    private static final long serialVersionUID = 3594108882868668611L;
    protected TextEditorArea m_TextArea;
    protected boolean m_Modified;
    protected boolean m_IgnoreChanges;
    protected transient TextFileChooser m_FileChooser;
    protected UndoManager m_Undo;
    protected String m_LastFind;
    protected HashSet<ChangeListener> m_ChangeListeners;
    protected File m_CurrentFile;
    protected String m_CurrentEncoding;
    protected PopupMenuCustomizer<TextEditorPanel> m_PopupMenuCustomizer;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_CurrentFile = null;
        this.m_CurrentEncoding = null;
        this.m_ChangeListeners = new HashSet();
        this.m_Undo = new UndoManager();
        this.m_PopupMenuCustomizer = null;
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_TextArea = new TextEditorArea();
        this.m_TextArea.setWrapStyleWord(true);
        this.m_TextArea.addSetTextListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                TextEditorPanel.this.m_TextArea.setCaretPosition(0);
                TextEditorPanel.this.setModified(false);
            }
        });
        this.m_TextArea.addAppendListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                TextEditorPanel.this.notifyChangeListeners();
            }
        });
        this.m_TextArea.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (MouseUtils.isRightClick(e)) {
                    e.consume();
                    TextEditorPanel.this.showPopupMenu(e);
                }
                if (!e.isConsumed()) {
                    super.mouseClicked(e);
                }
            }
        });
        this.m_TextArea.setFont(GUIHelper.getMonospacedFont());
        this.add((Component)new BaseScrollPane(this.m_TextArea), "Center");
        this.m_TextArea.getDocument().addUndoableEditListener(new UndoableEditListener(){

            @Override
            public void undoableEditHappened(UndoableEditEvent evt) {
                TextEditorPanel.this.m_Modified = true;
                TextEditorPanel.this.m_Undo.addEdit(evt.getEdit());
                TextEditorPanel.this.notifyChangeListeners();
            }
        });
        this.m_TextArea.getActionMap().put("Undo", new AbstractAction("Undo"){
            private static final long serialVersionUID = -3023997491519283074L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextEditorPanel.this.undo();
            }
        });
        this.m_TextArea.getInputMap().put(GUIHelper.getKeyStroke("control Z"), "Undo");
        this.m_TextArea.getActionMap().put("Redo", new AbstractAction("Redo"){
            private static final long serialVersionUID = -3579642465298206034L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextEditorPanel.this.redo();
            }
        });
        this.m_TextArea.getInputMap().put(GUIHelper.getKeyStroke("control Y"), "Redo");
        this.setSize(600, 800);
    }

    protected TextFileChooser getFileChooser() {
        if (this.m_FileChooser == null) {
            this.m_FileChooser = new TextFileChooser();
        }
        return this.m_FileChooser;
    }

    public void setModified(boolean value) {
        this.m_Modified = value;
        if (!this.m_Modified) {
            this.m_Undo.discardAllEdits();
        }
        this.notifyChangeListeners();
    }

    public boolean isModified() {
        return this.m_Modified;
    }

    public void setContent(String value) {
        this.m_TextArea.setText(value);
    }

    public String getContent() {
        return this.m_TextArea.getText();
    }

    public void append(String str) {
        this.m_TextArea.append(str);
    }

    public void setEditable(boolean value) {
        this.m_TextArea.setEditable(value);
    }

    public boolean isEditable() {
        return this.m_TextArea.isEditable();
    }

    public void setTextFont(Font value) {
        this.m_TextArea.setFont(value);
    }

    public Font getTextFont() {
        return this.m_TextArea.getFont();
    }

    public String getLastFind() {
        return this.m_LastFind;
    }

    public JTextArea getTextArea() {
        return this.m_TextArea;
    }

    public Document getDocument() {
        return this.m_TextArea.getDocument();
    }

    public void setCaretPosition(int value) {
        this.m_TextArea.setCaretPosition(value);
    }

    public int getCaretPosition() {
        return this.m_TextArea.getCaretPosition();
    }

    public void setTabSize(int value) {
        this.m_TextArea.setTabSize(value);
    }

    public int getTabSize() {
        return this.m_TextArea.getTabSize();
    }

    public void setLineWrap(boolean value) {
        this.m_TextArea.setLineWrap(value);
    }

    public boolean getLineWrap() {
        return this.m_TextArea.getLineWrap();
    }

    public boolean checkForModified() {
        boolean result;
        boolean bl = result = !this.isModified();
        if (!result) {
            String msg = "Content not saved - save?";
            int retVal = GUIHelper.showConfirmMessage(this, msg, "Content not saved");
            switch (retVal) {
                case 0: {
                    this.saveAs();
                    result = !this.isModified();
                    break;
                }
                case 1: {
                    result = true;
                    break;
                }
                case 2: {
                    result = false;
                }
            }
        }
        return result;
    }

    public boolean open() {
        int retVal = this.getFileChooser().showOpenDialog(this);
        if (retVal != 0) {
            return false;
        }
        return this.open(this.getFileChooser().getSelectedFile(), this.getFileChooser().getEncoding());
    }

    public boolean open(File file) {
        return this.open(file, null);
    }

    public boolean open(File file, String encoding) {
        List<String> content;
        boolean result;
        if (encoding == null || encoding.isEmpty()) {
            encoding = "UTF-8";
        }
        boolean bl = result = (content = FileUtils.loadFromFile(file, encoding)) != null;
        if (result) {
            this.setContent(Utils.flatten(content, "\n"));
            this.setModified(false);
            this.m_CurrentFile = file;
            this.m_CurrentEncoding = encoding;
        }
        this.notifyChangeListeners();
        return result;
    }

    public void save() {
        if (this.m_CurrentFile == null) {
            this.saveAs();
        } else {
            this.save(this.m_CurrentFile, this.m_CurrentEncoding);
        }
    }

    public void saveAs() {
        int retVal = this.getFileChooser().showSaveDialog(this);
        if (retVal != 0) {
            return;
        }
        this.save(this.getFileChooser().getSelectedFile(), this.getFileChooser().getEncoding());
    }

    protected void save(File file, String encoding) {
        if (!FileUtils.writeToFile(file.getAbsolutePath(), this.m_TextArea.getText(), false, encoding)) {
            GUIHelper.showErrorMessage(this, "Error saving content to file '" + file + "'!");
        } else {
            this.m_CurrentFile = file;
            this.m_CurrentEncoding = encoding;
            this.m_Modified = false;
        }
        this.notifyChangeListeners();
    }

    public void clear() {
        try {
            this.m_TextArea.getDocument().remove(0, this.m_TextArea.getDocument().getLength());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_Modified = false;
        this.notifyChangeListeners();
    }

    public boolean canUndo() {
        try {
            return this.m_Undo.canUndo();
        }
        catch (Exception ex) {
            return false;
        }
    }

    public void undo() {
        try {
            if (this.m_Undo.canUndo()) {
                this.m_Undo.undo();
            }
            if (!this.m_Undo.canUndo()) {
                this.m_Modified = false;
            }
            this.notifyChangeListeners();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean canRedo() {
        try {
            return this.m_Undo.canRedo();
        }
        catch (Exception ex) {
            return false;
        }
    }

    public void redo() {
        try {
            if (this.m_Undo.canRedo()) {
                this.m_Undo.redo();
                this.m_Modified = true;
                this.notifyChangeListeners();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean canCut() {
        return this.isEditable() && this.m_TextArea.getSelectedText() != null;
    }

    public void cut() {
        this.m_TextArea.cut();
        this.notifyChangeListeners();
    }

    public boolean canCopy() {
        return this.m_TextArea.getSelectedText() != null;
    }

    public void copy() {
        if (this.m_TextArea.getSelectedText() == null) {
            GUIHelper.copyToClipboard(this.m_TextArea.getText());
        } else {
            this.m_TextArea.copy();
        }
    }

    public boolean canPaste() {
        return this.isEditable() && GUIHelper.canPasteStringFromClipboard();
    }

    public void paste() {
        this.m_TextArea.paste();
        this.notifyChangeListeners();
    }

    public void selectAll() {
        this.m_TextArea.selectAll();
    }

    public void find() {
        String search = JOptionPane.showInputDialog(GUIHelper.getParentComponent(this), "Enter search string", this.m_LastFind);
        if (search == null) {
            return;
        }
        int index = this.m_TextArea.getText().indexOf(search, this.m_TextArea.getCaretPosition());
        if (index > -1) {
            this.m_LastFind = search;
            this.m_TextArea.setCaretPosition(index + search.length());
            this.m_TextArea.setSelectionStart(index);
            this.m_TextArea.setSelectionEnd(index + search.length());
        } else {
            GUIHelper.showErrorMessage(this, "Search string '" + search + "' not found!");
        }
        this.notifyChangeListeners();
    }

    public void findNext() {
        int index = this.m_TextArea.getText().indexOf(this.m_LastFind, this.m_TextArea.getCaretPosition());
        if (index > -1) {
            this.m_TextArea.setCaretPosition(index + this.m_LastFind.length());
            this.m_TextArea.setSelectionStart(index);
            this.m_TextArea.setSelectionEnd(index + this.m_LastFind.length());
        } else {
            GUIHelper.showErrorMessage(this, "Search string '" + this.m_LastFind + "' not found!");
        }
        this.notifyChangeListeners();
    }

    public void printText() {
        this.m_TextArea.printText();
    }

    public void selectFont() {
        this.m_TextArea.selectFont();
    }

    public File getCurrentFile() {
        return this.m_CurrentFile;
    }

    public String getCurrentEncoding() {
        return this.m_CurrentEncoding;
    }

    public void addChangeListener(ChangeListener l) {
        this.m_ChangeListeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.m_ChangeListeners.add(l);
    }

    protected void notifyChangeListeners() {
        ChangeEvent e = new ChangeEvent(this);
        for (ChangeListener l : this.m_ChangeListeners) {
            l.stateChanged(e);
        }
    }

    public void setPopupMenuCustomizer(PopupMenuCustomizer<TextEditorPanel> value) {
        this.m_PopupMenuCustomizer = value;
    }

    public PopupMenuCustomizer<TextEditorPanel> getPopupMenuCustomizer() {
        return this.m_PopupMenuCustomizer;
    }

    protected void showPopupMenu(MouseEvent e) {
        JPopupMenu menu = new JPopupMenu();
        JMenuItem menuitem = new JMenuItem("Copy", GUIHelper.getIcon("copy.gif"));
        menuitem.setEnabled(this.m_TextArea.getSelectedText() != null);
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextEditorPanel.this.m_TextArea.requestFocus();
                GUIHelper.copyToClipboard(TextEditorPanel.this.m_TextArea.getSelectedText());
            }
        });
        menu.add(menuitem);
        menuitem = new JMenuItem("Select all", GUIHelper.getEmptyIcon());
        menuitem.setEnabled(this.m_TextArea.getText().length() > 0);
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextEditorPanel.this.m_TextArea.requestFocus();
                TextEditorPanel.this.m_TextArea.setSelectionStart(0);
                TextEditorPanel.this.m_TextArea.setSelectionEnd(TextEditorPanel.this.m_TextArea.getText().length());
            }
        });
        menu.add(menuitem);
        menuitem = new JCheckBoxMenuItem("Line wrap", GUIHelper.getEmptyIcon());
        menuitem.setSelected(this.getLineWrap());
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextEditorPanel.this.setLineWrap(!TextEditorPanel.this.getLineWrap());
            }
        });
        menu.addSeparator();
        menu.add(menuitem);
        if (this.m_PopupMenuCustomizer != null) {
            this.m_PopupMenuCustomizer.customizePopupMenu(this, menu);
        }
        menu.show(this.m_TextArea, e.getX(), e.getY());
    }

    @Override
    public ExtensionFileFilter getCustomTextFileFilter() {
        return null;
    }

    @Override
    public String supplyText() {
        return this.getContent();
    }

    public static class TextEditorArea
    extends BaseTextArea {
        private static final long serialVersionUID = -7941638500983219814L;
        protected HashSet<ChangeListener> m_SetTextListeners = new HashSet();
        protected HashSet<ChangeListener> m_AppendListeners = new HashSet();

        @Override
        public void setText(String value) {
            super.setText(value);
            this.notifySetTextListeners();
        }

        @Override
        public void append(String value) {
            super.append(value);
            this.notifyAppendListeners();
        }

        public void addSetTextListener(ChangeListener l) {
            this.m_SetTextListeners.add(l);
        }

        public void removeSetTextListener(ChangeListener l) {
            this.m_SetTextListeners.remove(l);
        }

        protected void notifySetTextListeners() {
            ChangeEvent e = new ChangeEvent(this);
            for (ChangeListener l : this.m_SetTextListeners) {
                l.stateChanged(e);
            }
        }

        public void addAppendListener(ChangeListener l) {
            this.m_AppendListeners.add(l);
        }

        public void removeAppendListener(ChangeListener l) {
            this.m_AppendListeners.remove(l);
        }

        protected void notifyAppendListeners() {
            ChangeEvent e = new ChangeEvent(this);
            for (ChangeListener l : this.m_AppendListeners) {
                l.stateChanged(e);
            }
        }
    }
}

